#include "types.h"
#include "stdio.h"
#include "../sdcore/api.h"
#include "../sdcore/state.h"
#include "../lib8973/bpstate.h"
#include "../lib8973/bermeter.h"

extern struct sdcore_api *fetch_sdcore();
extern caddr_t malloc();
extern caddr_t malloc_end;

struct sdcore_api *sdcore_api;
struct sdcore_state sdcore_state;

int hdlc_running;

extern int show_meters_raw;
extern struct ber_meter_state berstate;

ndebug()
{
	if (sdcore_init() < 0) {
		/* error message already printed */
		return(-1);
	}
	printf("NDEBUG utility running, end address %08X\r\n", malloc_end);
	sdcore_api->btreset(&sdcore_state);
	hdlc_running = 0;
	show_meters_raw = 0;
	bzero(&berstate, sizeof berstate);
	console();
	scc_stop();
	return(0);
}

sdcore_init()
{
	caddr_t privstate;

	sdcore_api = fetch_sdcore();
	if (!sdcore_api) {
		/* error message already printed */
		return(-1);
	}
	privstate = malloc(sdcore_api->sizeof_privstate);
	sdcore_api->swinit(&sdcore_state, privstate);
	return(0);
}
