/*
 * Packet queue management
 */

#include "types.h"
#include "../l2conv/struct.h"
#include "pktqueue.h"

put_buffer_on_queue(buf, q)
	struct buffer *buf;
	struct pktqueue *q;
{
	int s;

	buf->buf_next = NULL;
	s = spl7();
	if (q->q_count) {
		q->q_tail->buf_next = buf;
		q->q_tail = buf;
		q->q_count++;
	} else {
		q->q_head = buf;
		q->q_tail = buf;
		q->q_count = 1;
	}
	splx(s);
}

struct buffer *
get_buffer_from_queue(q)
	struct pktqueue *q;
{
	int s;
	struct buffer *buf;

	s = spl7();
	buf = q->q_head;
	if (!buf)
		goto out;
	q->q_head = buf->buf_next;
	q->q_count--;
	if (!q->q_count)
		q->q_tail = NULL;
out:	splx(s);
	return(buf);
}
