#include "types.h"
#include "ctype.h"
#include "strings.h"
#include "stdio.h"
#include "monitor_api.h"
#include "globals.h"

get_config()
{
	int i;

	i = get_debug_modes();
	if (i < 0)
		return(i);
	i = opcore_api->get_ttype();
	if (i < 0)
		return(i);
	if (debug_modes) {
		i = opcore_api->get_preact_type();
		if (i < 0)
			return(i);
	}
	if (!sdcore_state.terminal_type || !sdcore_state.preact_type) {
		i = opcore_api->get_datarate();
		if (i < 0)
			return(i);
	}
	if (!sdcore_state.terminal_type &&
	    sdcore_state.preact_type == PREACT_TYPE_AUTOBAUD) {
		i = opcore_api->get_ab_flavor();
		if (i < 0)
			return(i);
	}
	i = get_frame_acqu_time();
	if (i < 0)
		return(i);
	i = get_lost_timeout();
	if (i < 0)
		return(i);
	i = get_losw_count();
	if (i < 0)
		return(i);
	i = get_nokia_idle();
	if (i < 0)
		return(i);
	i = get_eoc_octet();
	if (i < 0)
		return(i);
	return(0);
}

get_frame_acqu_time()
{
	char *s;
	int val;

	s = opcore_api->config_search("frame_acqu_time");
	if (!s) {
		val = 10;	/* 10 s default */
		goto set;
	}
	if (!opcore_api->is_string_num(s)) {
inv:		monapi_error("frame_acqu_time=%s: invalid setting", s);
		return(-1);
	}
	val = atoi(s);
	if (!val)
		goto inv;
set:	frame_acqu_time = val * 20;
	return(0);
}

get_lost_timeout()
{
	char *s;
	int val;

	s = opcore_api->config_search("los_lost_timeout");
	if (!s) {
		val = 30;	/* 30 s default */
		goto set;
	}
	if (!opcore_api->is_string_num(s)) {
		monapi_error("los_lost_timeout=%s: invalid setting", s);
		return(-1);
	}
	val = atoi(s);
set:	los_lost_timeout = val * 20;
	return(0);
}

get_losw_count()
{
	char *s;
	int val;

	s = opcore_api->config_search("nokia_losw_count");
	if (!s) {
		val = 7;	/* default from Hack-o-Rocket */
		goto set;
	}
	if (!opcore_api->is_string_num(s)) {
inv:		monapi_error("nokia_losw_count=%s: invalid setting", s);
		return(-1);
	}
	val = atoi(s);
	if (!val)
		goto inv;
set:	nokia_losw_count = val;
	return(0);
}

get_nokia_idle()
{
	char *s;
	int val;

	s = opcore_api->config_search("initial_idle_frames");
	if (!s) {
		val = 50;	/* default from Hack-o-Rocket */
		goto set;
	}
	if (!opcore_api->is_string_num(s)) {
		monapi_error("initial_idle_frames=%s: invalid setting", s);
		return(-1);
	}
	val = atoi(s);
set:	nokia_initial_idle = val;
	return(0);
}

get_debug_modes()
{
	char *s;
	int bool;

	s = opcore_api->config_search("debug_modes");
	if (!s) {
		debug_modes = 0;	/* default no of course */
		return(0);
	}
	bool = opcore_api->parse_boolean_param(s);
	if (bool < 0) {
		monapi_error("debug_modes=%s: invalid setting", s);
		return(-1);
	}
	debug_modes = bool;
	if (debug_modes)
		printf("Debug modes enabled: make sure you know what you are doing!\r\n");
	return(0);
}

get_eoc_octet()
{
	char *s;
	int i;
	u_long accum;

	s = opcore_api->config_search("eoc_octet");
	if (!s) {
		/* what Netopia and EN do for Flavor N1 */
		tx_eoc_octet = 0xFF;
		return(0);
	}
	if (!isxdigit(s[0]) || !isxdigit(s[1]) || s[2]) {
		monapi_error("eoc_octet=%s: invalid setting", s);
		return(-1);
	}
	for (i = 0, accum = 0; i < 2; i++, s++) {
		accum <<= 4;
		if (isdigit(*s))
			accum += *s - '0';
		else if (isupper(*s))
			accum += *s - 'A' + 10;
		else
			accum += *s - 'a' + 10;
	}
	tx_eoc_octet = accum;
	return(0);
}
