#include "types.h"
#include "stdio.h"
#include "mc68302.h"
#include "gpio.h"
#include "intr.h"
#include "sccsave.h"
#include "excstate.h"

extern caddr_t m68000_vectors[];
extern volatile struct mc68302_regs mc68302_regs;
extern volatile struct mc68302_scc_params scc1_params, scc2_params;

extern char _Xvec_sdmaerr;
extern char _Xvec_badirq6;
extern char _Xvec_rte;
extern char _Xvec_swtimer;
extern char console_restart_entry;

extern volatile long timebase;
extern u_long last_memacc_addr;
extern u_short last_memacc_size;
extern struct scc_saved_initstate scc1_saved_initstate, scc2_saved_initstate;

sysinit()
{
	serial_init();
	printf("\r\nOSDCU monitor initializing\r\n");
	/* interrupts and exceptions */
	copy_vectors_to_ram();
	mc68302_regs.gimr = 0x8040;
	m68000_vectors[INTVEC_ERROR] = &_Xvec_rte;
	m68000_vectors[INTVEC_SDMAERR] = &_Xvec_sdmaerr;
	mc68302_regs.imr |= INTMASK_SDMAERR;
	m68000_vectors[INTVEC_IRQ6] = &_Xvec_badirq6;
	spl1();
	/* 50 ms software timer */
	mc68302_regs.timer1.trr = 46080;
	mc68302_regs.timer1.tmr = 0x011F;
	m68000_vectors[INTVEC_TIMER1] = &_Xvec_swtimer;
	timebase = 0;
	mc68302_regs.imr |= INTMASK_TIMER1;
	/* bitpump */
	mc68302_regs.or2 = 0xFFFC;
	mc68302_regs.br2 = 0xAC01;
	if (lib8973_first_init() < 0) {
		/* bitpump self-test failed! */
		montrap_set_ledmctl();
		last_memacc_addr = 0;
		last_memacc_size = 4;
		return(-1);
	}
	bp_power_down();
	spl0();
	/*
	 * SCCs
	 *
	 * RCLK1 and TCLK1 need to be inputs.
	 * Make BRG1 tick at SYSCLK/100 initially
	 * (we'll be making an ECO to use it instead of 2xBCLK)
	 *
	 * RCLK2 and TCLK2 are also inputs on the current PCB
	 * and we don't have BRG2 output brought out.
	 */
	mc68302_regs.scc1.scon = 0x30C6;
	mc68302_regs.scc2.scon = 0x3FFE;
	scc1_saved_initstate.rx_int_state = scc1_params.rx_int_state;
	scc1_saved_initstate.rbdn = scc1_params.rbdn;
	scc1_saved_initstate.tx_int_state = scc1_params.tx_int_state;
	scc1_saved_initstate.tbdn = scc1_params.tbdn;
	scc2_saved_initstate.rx_int_state = scc2_params.rx_int_state;
	scc2_saved_initstate.rbdn = scc2_params.rbdn;
	scc2_saved_initstate.tx_int_state = scc2_params.tx_int_state;
	scc2_saved_initstate.tbdn = scc2_params.tbdn;
	/* global variables */
	last_memacc_addr = 0;
	last_memacc_size = 4;
	/* indicate init done */
	mc68302_regs.padat &= ~PORTA_LSLED_MASK;
	mc68302_regs.pbdat &= ~(PORTB_DSR | PORTB_CD | PORTB_CTS | PORTB_MISC7);
	return(0);
}

console_init(excstate)
	u_long *excstate;
{
	excstate[EXCSTATE_PC] = (u_long) &console_restart_entry;
	excstate[EXCSTATE_SR] = 0x2700;
}
