#include "types.h"
#include "mc68302.h"
#include "cp.h"

extern volatile struct mc68302_regs mc68302_regs;
extern volatile struct mc68302_scc_bd scc3_rx_bds[8];
extern volatile struct mc68302_scc_bd scc3_tx_bds[4];
extern volatile struct mc68302_scc_uartparams scc3_params;
extern char _printf_buffers[4][128];
extern volatile u_char _getchar_buffer[8];
extern u_short _printf_curbd, _getchar_headptr;

u_short
uart_baudrate_to_scon(baudrate)
{
	return (115200 / baudrate - 1) << 1 | 0x4000;
}

serial_init()
{
	int i;

	mc68302_regs.scc3.scon = uart_baudrate_to_scon(9600);
	mc68302_regs.scc3.scm = SCM_UART_CL | SCM_UART_RTSM | SCM_SOFT_CTS_CD
				| SCM_MODE_ASYNC;
	for (i = 0; i < 8; i++) {
		scc3_rx_bds[i].bd_flags = 0x8000;
		scc3_rx_bds[i].bd_bufptr = _getchar_buffer + i;
	}
	scc3_rx_bds[7].bd_flags = 0xA000;
	_getchar_headptr = 0;
	for (i = 0; i < 4; i++) {
		scc3_tx_bds[i].bd_flags = 0;
		scc3_tx_bds[i].bd_bufptr = _printf_buffers[i];
	}
	scc3_tx_bds[3].bd_flags = 0x2000;
	_printf_curbd = 0;
	scc3_params.rfcr = 0x50;
	scc3_params.tfcr = 0x50;
	scc3_params.mrblr = 1;
	scc3_params.max_idl = 1;
	scc3_params.brkcr = 0;
	scc3_params.parec = 0;
	scc3_params.frmec = 0;
	scc3_params.nosec = 0;
	scc3_params.brkec = 0;
	scc3_params.ctlchar[0] = 0x8000;
	scc3_params.ctlchar[7] = 0;
	mc68302_regs.scc3.scm |= SCM_ENR | SCM_ENT;
}
