#include "mc68302_asm.h"

	.text
	.globl	start
start:	.long	0x00FFFFFC	/* no RAM, hence no useful SSP */
	.long	reset_entry-start
	.long	_Xvec_buserr
	.long	_Xvec_address
	.long	_Xvec_illegal
	.long	_Xvec_zerodiv
	.long	_Xvec_chk
	.long	_Xvec_trapv
	.long	_Xvec_priv
	.long	_Xvec_trace
	.long	_Xvec_line1010
	.long	_Xvec_line1111
	.long	_Xvec_default
	.long	_Xvec_default
	.long	_Xvec_default
	.long	_Xvec_uninit
	.long	_Xvec_default
	.long	_Xvec_default
	.long	_Xvec_default
	.long	_Xvec_default
	.long	_Xvec_default
	.long	_Xvec_default
	.long	_Xvec_default
	.long	_Xvec_default
	.long	_Xvec_spur
	.long	_Xvec_avec1
	.long	_Xvec_avec2
	.long	_Xvec_avec3
	.long	_Xvec_avec4
	.long	_Xvec_avec5
	.long	_Xvec_avec6
	.long	_Xvec_avec7
	.rept	16
	.long	_Xvec_trap
	.endr
	.rept	208
	.long	_Xvec_default
	.endr

/*
 * Reset entry.
 * We have to be very careful here because we are currently mapped at 0
 * and not at our link address.
 *
 * Set up the BAR, basic GPIO init, set sensible OR0 for the ROM, and
 * gain the ability to blink LEDs.
 */
reset_entry:
	move.w	#0xA700,BAR
	move.w	#0x1E00,OR0
	move.w	#0x030F,PACNT
	move.w	#0x8850,PADAT
	move.w	#0xFCF0,PADDR
	move.w	#0x0008,PBCNT
	clr.w	PBDAT
	move.w	#0x02C7,PBDDR
/* Now we can do the ROM/RAM gymnastics. */
	lea	romcs_switch_code(%pc),%a0
	movea.l	#onchip_ram,%a1
	move.w	#((romcs_switch_code_end-romcs_switch_code)/2-1),%d0
1:	move.w	(%a0)+,(%a1)+
	dbra	%d0,1b
	jmp	onchip_ram:l
romcs_switch_code:
	move.w	#0xC401,BR0
	jmp	romcs_switched_reentry:l
romcs_switch_code_end:
	.org	0x5FC
	.long	external_api_table
romcs_switched_reentry:
/*
 * We are now running where we are supposed to be, much better.
 */
	move.w	#0x1E00,OR1
	move.w	#0xA001,BR1
	/* it sure feels good to have RAM */
	movea.l	#0x00FFB8,%a7	/* we can have a stack now, yay! */
	clr.l	in_cmd_script
/* We can now run C code! */
	jsr	sysinit
	tst.l	%d0
	bneb	1f
	jsr	operboot
1:	move.l	%a7,%a6
	move.l	%a6,-(%a7)
	jsr	console_init
	jsr	console
	addq.l	#4,%a7
	tst.l	%d0
	bneb	1b
	jmp	exception_exit
