/*
 * FFS subcommands are dispatched here.
 * Read commands are implemented here;
 * write commands are split out into ffswrite.c.
 */

#include "types.h"
#include "stdio.h"
#include "ctype.h"
#include "strings.h"
#include "mon302.h"
#include "rt11ffs.h"
#include "../libffs/ffsimpl.h"

extern int cmd_ffs_textdump();
extern struct keyword hexdump_quals[];

extern int cmd_ffs_delete();
extern int cmd_ffs_erase();
extern int cmd_ffs_initialize();
extern int cmd_ffs_store();

cmd_ffs_directory(cmd)
	char *cmd;
{
	if (parse_cmd(cmd, 0, 0, NULL, NULL, NULL, NULL))
		return(0);
	ffs_scan_flash(1, NULL);
	return(0);
}

cmd_ffs_hexdump(cmd)
	char *cmd;
{
	struct param params[1];
	struct qual quals[1];
	u_short filename_rad50[3];
	struct find_file_results findstruct;
	u_char *cp, *end;
	u_char buf[16];
	int idx, i, c;

	quals[0].id = 0;
	if (parse_cmd(cmd, 1, 1, params, NULL, hexdump_quals, quals))
		return(0);
	if (quals[0].id && quals[0].value) {
		error("No value qualifier");
		return(0);
	}
	if (ascii_to_rad50_filename(params[0].text, params[0].len,
					filename_rad50, 0) < 0) {
		error("Invalid filename");
		return(0);
	}
	if (ffs_find_file_wrapper(filename_rad50, &findstruct) < 0)
		return(0);
	for (idx = 0; idx < findstruct.nfrags; idx++) {
		cp = findstruct.frags[idx].addr;
		end = cp + findstruct.frags[idx].nblks * RT11FFS_AU_SIZE;
		for (; cp < end; cp += 16) {
			if (check_intr())
				return(0);
			bcopy(cp, buf, 16);
			printf("%08X:", cp);
			for (i = 0; i < 16; i++) {
				if ((i & 3) == 0)
					putchar(' ');
				printf(" %02X", buf[i]);
			}
			if (quals[0].id) {
				printf("  ");
				for (i = 0; i < 16; i++) {
					c = buf[i];
					if (!isprint(c))
						c = '.';
					putchar(c);
				}
			}
			printf("\r\n");
		}
	}
	return(0);
}

static const struct keyword ffs_subcmds[] = {
	{"DELETE", 2, (long) &cmd_ffs_delete},
	{"DIRECTORY", 2, (long) &cmd_ffs_directory},
	{"ERASE", 1, (long) &cmd_ffs_erase},
	{"HEXDUMP", 1, (long) &cmd_ffs_hexdump},
	{"INITIALIZE", 1, (long) &cmd_ffs_initialize},
	{"STORE", 1, (long) &cmd_ffs_store},
	{"TEXTDUMP", 1, (long) &cmd_ffs_textdump},
	{NULL, 0, -1}};

cmd_ffs(cmd)
	char *cmd;
{
	char *cp = cmd, *subcmd;
	int count;
	void (*subcmdfunc)();
	int ambigsubcmd;

	while (*cp == ' ')
		cp++;
	if (!issym(*cp)) {
		error("Subcommand required");
		return(0);
	}
	for (subcmd = cp, count = 0; issym(*cp); cp++)
		count++;
	ambigsubcmd = 0;
	subcmdfunc = (void (*)())
			find_keyword(subcmd, count, ffs_subcmds, &ambigsubcmd);
	if ((long) subcmdfunc != -1)
		(*subcmdfunc)(cp);
	else {
		if (ambigsubcmd)
			error("Ambiguous subcommand");
		else
			error("Illegal subcommand");
	}
	return(0);
}
