/*
 * Here are the assembly handlers to which all exception vectors
 * are initially pointed.
 */

	.text

#define	GEN_HANDLER(veclabel,namestr) \
	.globl	veclabel; \
veclabel: \
	clr.w	-(%a7); \
	movem.l	#0xFFFE,-(%a7); \
	lea	namestr,%a0; \
	jbra	exception_common

GEN_HANDLER(_Xvec_illegal,xstr_illegal)
GEN_HANDLER(_Xvec_zerodiv,xstr_zerodiv)
GEN_HANDLER(_Xvec_chk,xstr_chk)
GEN_HANDLER(_Xvec_trapv,xstr_trapv)
GEN_HANDLER(_Xvec_priv,xstr_priv)
GEN_HANDLER(_Xvec_trace,xstr_trace)
GEN_HANDLER(_Xvec_line1010,xstr_line1010)
GEN_HANDLER(_Xvec_line1111,xstr_line1111)
GEN_HANDLER(_Xvec_uninit,xstr_uninit)
GEN_HANDLER(_Xvec_spur,xstr_spur)
GEN_HANDLER(_Xvec_avec1,xstr_avec1)
GEN_HANDLER(_Xvec_avec2,xstr_avec2)
GEN_HANDLER(_Xvec_avec3,xstr_avec3)
GEN_HANDLER(_Xvec_avec4,xstr_avec4)
GEN_HANDLER(_Xvec_avec5,xstr_avec5)
GEN_HANDLER(_Xvec_avec6,xstr_avec6)
GEN_HANDLER(_Xvec_avec7,xstr_avec7)
GEN_HANDLER(_Xvec_trap,xstr_trap)
GEN_HANDLER(_Xvec_default,xstr_default)
GEN_HANDLER(_Xvec_badirq6,xstr_badirq6)

exception_common:
	move.l	%a7,%a6
	move.l	0x3C(%a6),-(%a7)
	move.l	0x40(%a6),-(%a7)
	move.l	%a0,-(%a7)
	pea	xstr_format
	jsr	printf
	adda.w	#16,%a7
exception_common2:
	jsr	montrap_set_ledmctl
	clr.l	in_cmd_script
	move.l	%a6,-(%a7)
	jsr	console
	addq.l	#4,%a7
	tst.l	%d0
	jbne	console_restart_entry
	jbra	exception_exit

	.globl	_Xvec_buserr
_Xvec_buserr:
	movem.l	#0xC0C0,-(%a7)
	pea	xstr_buserr
	jsr	printf
	addq.l	#4,%a7
	move.l	%a7,%a0
	pea	16(%a0)
	jsr	print_buserr_frame
	addq.l	#4,%a7
	movem.l	(%a7)+,#0x0303
	addq.l	#8,%a7
	clr.w	-(%a7)
	movem.l	#0xFFFE,-(%a7)
	move.l	%a7,%a6
	jbra	exception_common2

	.globl	_Xvec_address
_Xvec_address:
	movem.l	#0xC0C0,-(%a7)
	pea	xstr_address
	jsr	printf
	addq.l	#4,%a7
	move.l	%a7,%a0
	pea	16(%a0)
	jsr	print_buserr_frame
	addq.l	#4,%a7
	movem.l	(%a7)+,#0x0303
	addq.l	#8,%a7
	clr.w	-(%a7)
	movem.l	#0xFFFE,-(%a7)
	move.l	%a7,%a6
	jbra	exception_common2

	.globl	_Xvec_sdmaerr
_Xvec_sdmaerr:
	clr.w	-(%a7)
	movem.l	#0xFFFE,-(%a7)
	jsr	handle_sdma_buserr
	move.l	%a7,%a6
	jbra	exception_common2

	.globl	console_restart_entry
	.globl	exception_exit
	.globl	_Xvec_rte
console_restart_entry:
	movea.l	#0x00FFB8,%a7
1:	move.l	%a7,%a6
	move.l	%a6,-(%a7)
	jsr	console_init
	jsr	console
	addq.l	#4,%a7
	tst.l	%d0
	bneb	1b
exception_exit:
	movem.l	(%a7)+,#0x7FFF
	addq.l	#2,%a7
_Xvec_rte:
	rte

	.section	.rodata
xstr_format:
	.asciz	"\r\n?EXCEPTION: %s\r\nPC=%08X  SR=%04X\r\n"
xstr_buserr:
	.asciz	"\r\n?BUS ERROR\r\n"
xstr_address:
	.asciz	"\r\n?ADDRESS ERROR\r\n"
xstr_illegal:
	.asciz	"Illegal Instruction"
xstr_zerodiv:
	.asciz	"Zero Divide"
xstr_chk:
	.asciz	"CHK"
xstr_trapv:
	.asciz	"TRAPV"
xstr_priv:
	.asciz	"Privilege Violation"
xstr_trace:
	.asciz	"Trace"
xstr_line1010:
	.asciz	"line 1010"
xstr_line1111:
	.asciz	"line 1111"
xstr_uninit:
	.asciz	"Uninitialized Interrupt Vector"
xstr_spur:
	.asciz	"Spurious Interrupt"
xstr_avec1:
	.asciz	"Level 1 AVEC"
xstr_avec2:
	.asciz	"Level 2 AVEC"
xstr_avec3:
	.asciz	"Level 3 AVEC"
xstr_avec4:
	.asciz	"Level 4 AVEC"
xstr_avec5:
	.asciz	"Level 5 AVEC"
xstr_avec6:
	.asciz	"Level 6 AVEC"
xstr_avec7:
	.asciz	"Level 7 AVEC"
xstr_trap:
	.asciz	"TRAP #n"
xstr_default:
	.asciz	"default handler"
xstr_badirq6:
	.asciz	"FPGA IRQ handler not installed"
