#ifndef __HEC_H
#define	__HEC_H

/* Fast inline ATM HEC computation */
extern const u_char crc8_table[256];

static inline u_char
compute_hec(cellhdr)
	u_char *cellhdr;
{
	u_char crc;

	crc = crc8_table[cellhdr[0]];
	crc = crc8_table[crc ^ cellhdr[1]];
	crc = crc8_table[crc ^ cellhdr[2]];
	crc = crc8_table[crc ^ cellhdr[3]];
	return(crc ^ 0x55);
}

#endif	/* __HEC_H */
