/*
 * This routine computes MSB-first CRC-32 of a block of octets.
 */

#include "types.h"

extern u_long crc32_table[256];

u_long
crc32(crc, buf, len)
	u_long crc;
	u_char *buf;
	int len;
{
	while (len--)
		crc = crc32_table[(crc >> 24) ^ *buf++] ^ (crc << 8);
	return(crc);
}
