/*
 * This function checks a buffer for good FCS-16 per RFC 1662 rules.
 */

#include "types.h"

#define	CCITT_FCS16_INIT	0xffff		/* Initial FCS value */
#define	CCITT_FCS16_GOOD	0xf0b8		/* Good final FCS value */

extern u_short ccitt_fcs16tab[256];

rfc1662_fcs16_good(buf, len)
	u_char *buf;
	int len;
{
	u_short accum;

	accum = CCITT_FCS16_INIT;
	while (len--)
		accum = (accum >> 8) ^ ccitt_fcs16tab[(accum ^ *buf++) & 0xff];
	return(accum == CCITT_FCS16_GOOD);
}
