#include "../libc/types.h"
#include "paste.h"

tx_cm_preact(wb, speed)
	struct paste_workbuf *wb;
	int speed;
{
	int nshort, i;
	u_char *dp;

	switch (speed) {
	case 160:
		nshort = 0;
		break;
	case 208:
		nshort = 1;
		break;
	case 320:
		nshort = 2;
		break;
	case 416:
		nshort = 3;
		break;
	case 392:
		nshort = 4;
		break;
	case 784:
		nshort = 5;
		break;
	case 1040:
		nshort = 6;
		break;
	case 1568:
		nshort = 7;
		break;
	case 2320:
		nshort = 8;
		break;
	default:
		return(-1);
	}

	dp = wb->data;
	*dp++ = 0x86;	/* 300 ms pulse */
	*dp++ = 3;	/* 150 ms pause */
	for (i = 0; i < nshort; i++) {
		*dp++ = 0x83;	/* 150 ms pulse */
		*dp++ = 3;	/* 150 ms pause */
	}
	*dp++ = 0x8C;	/* 600 ms pulse */
	*dp++ = 2;	/* 100 ms pause */
	*dp = 0;

	return(tx_preact_signal_50ms(wb));
}
