#include "../libc/types.h"
#include "autobaud.h"
#include "paste.h"

tx_autobaud_msg(wb, msg, prepause)
	struct paste_workbuf *wb;
	u_long msg;
	int prepause;
{
	u_char *dp;
	u_long mask;

	dp = wb->data;
	if (prepause)
		*dp++ = prepause;
	*dp++ = 0x81;	/* start bit */
	for (mask = 0x80000000; mask; mask >>= 1) {
		if (msg & mask)
			*dp++ = 0x81;
		else
			*dp++ = 0x01;
	}
	*dp = 0;
	return(tx_preact_signal_50ms(wb));
}

tx_autobaud_msg_csum(wb, msg, prepause)
	struct paste_workbuf *wb;
	union autobaud_msg *msg;
	int prepause;
{
	msg->bytes[3] = msg->bytes[0] ^ msg->bytes[1] ^ msg->bytes[2];
	return(tx_autobaud_msg(wb, msg->word, prepause));
}
