/*
 * Pre-Activation Signal Transmission Engine
 */

#include "../libc/types.h"
#include "../lib8973/typedefs.h"
#include "../lib8973/bitpump.h"
#include "../lib8973/util.h"
#include "../lib8973/bpstate.h"
#include "paste.h"

static void
cleanup()
{
	DECLARE_MODE_PTR;

	bp_mode_ptr->mask_low_reg.t3 = 1;
	BP_global_state.t3_inthandler = 0;
	BP_WRITE_BIT(bp_mode_ptr, timer_continous, t3, OFF);
}

static void
t3_inthandler(wb)
	struct paste_workbuf *wb;
{
	DECLARE_MODE_PTR;

	switch (wb->state) {
	case PASTE_STATE_STARTINT:
		if (!wb->data[wb->idx]) {
			bp_mode_ptr->transmitter_modes.transmitter_off = 1;
			cleanup();
			wb->state = PASTE_STATE_DONE;
			return;
		}
		if (wb->data[wb->idx] & 0x80) {
			bp_mode_ptr->transmitter_modes.transmitter_off = 0;
			wb->data[wb->idx] &= 0x7F;
		} else
			bp_mode_ptr->transmitter_modes.transmitter_off = 1;
		wb->state = PASTE_STATE_MIDINT;
		/* FALL THRU */
	case PASTE_STATE_MIDINT:
		if (--wb->data[wb->idx] == 0) {
			wb->idx++;
			wb->state = PASTE_STATE_STARTINT;
		}
	}
}

tx_preact_signal(wb, unitint)
	struct paste_workbuf *wb;
	int unitint;
{
	DECLARE_PTR;
	DECLARE_MODE_PTR;
	int s;

	wb->state = PASTE_STATE_STARTINT;
	wb->idx = 0;
	s = splup(1);
	BP_global_state.t3_inthandler = t3_inthandler;
	BP_global_state.t3_inthandler_param = (u_long) wb;
	SET_WORD(bp_ptr, t3_low, t3_high, unitint);
	BP_WRITE_BIT(bp_mode_ptr, timer_continous, t3, ON);
	BP_WRITE_BIT(bp_mode_ptr, timer_restart, t3, ON);
	bp_mode_ptr->mask_low_reg.t3 = 0;
	bp_ptr->timer_source = ~TIMERMASK_T3;
	splx(s);
	return(0);
}

tx_preact_signal_50ms(wb)
	struct paste_workbuf *wb;
{
	return(tx_preact_signal(wb, BP_global_state.symbol_rate * 200));
}
