OUTPUT_ARCH(m68k)
__DYNAMIC = 0;
SECTIONS
{
  m68000_vectors = 0;
  /* everything in RAM: */
  .text  Base_addr  :
  {
    *(.text)
    *(.rodata)
    *(.rodata1)
  }
  etext = .;
  .data  :
  {
    *(.data)
    *(.data1)
  }
  edata = .;
  .bss  :
  {
    *(.bss)
    *(COMMON)
  }
  end = .;
  /* low memory globals */
  .lowmem  0x400  :
  {
    *(gds)
  }
  /* MC68302 on-chip block: */
  onchip_block 0x700000 :
  {
    /* user RAM */
    *(ocr)
    . = 0x400;
    scc1_rx_bds = .;
    . = 0x440;
    scc1_tx_bds = .;
    . = 0x480;
    scc1_params = .;
    . = 0x500;
    scc2_rx_bds = .;
    . = 0x540;
    scc2_tx_bds = .;
    . = 0x580;
    scc2_params = .;
    . = 0x600;
    scc3_rx_bds = .;
    . = 0x640;
    scc3_tx_bds = .;
    . = 0x680;
    scc3_params = .;
    . = 0x800;
    mc68302_regs = .;
  }
  Bitpump_regs          = 0x600000;
  monitor_api_table_ptr = 0x2005FC;
}
