/*
 * RT11FFS code developed by Harhan Engineering Co.
 */

#include "types.h"
#include "stdio.h"
#include "rt11ffs.h"
#include "ffsimpl.h"

extern struct rt11ffs_dirent ffs_segment_header;
extern struct rt11ffs_dirent blank_dirent;

ffs_find_fragment(segbase, filename, result, firstlast)
	caddr_t segbase;
	u_short *filename;
	struct fragment_info *result;
	u_short *firstlast;
{
	int blkptr;
	struct rt11ffs_dirent *dirptr;
	int dirindex;
	int size;

	dirptr = (struct rt11ffs_dirent *) segbase;
	if (bcmp(dirptr, &ffs_segment_header, sizeof ffs_segment_header))
		return(FIND_STAT_NOTFOUND);
	dirptr++;
	dirindex = 1;
	blkptr = 1;
	while (blkptr < FFS_AUs_PER_SEGMENT) {
		if (dirindex >= 64) {
			dirptr = (struct rt11ffs_dirent *)
					(segbase + blkptr++ * RT11FFS_AU_SIZE);
			dirindex = 0;
		}
		if (!bcmp(dirptr, &blank_dirent, sizeof(struct rt11ffs_dirent)))
			break;
		if (dirptr->filename[0] > 63999 || dirptr->filename[1] > 63999
		    || dirptr->filename[2] > 63999)
			return(FIND_STAT_INVALID_DIR);
		size = dirptr->size_flags & RT11FFS_DIRENT_SIZEMASK;
		if (size < 1 || size > (FFS_AUs_PER_SEGMENT - blkptr))
			return(FIND_STAT_INVALID_DIR);
		if ((dirptr->size_flags & RT11FFS_DIRENT_VALID) &&
		    !bcmp(dirptr->filename, filename, 6)) {
			result->addr = segbase + blkptr * RT11FFS_AU_SIZE;
			result->nblks = size;
			*firstlast = dirptr->size_flags &
				(RT11FFS_DIRENT_FIRST|RT11FFS_DIRENT_LAST);
			return(FIND_STAT_FOUND);
		}
		blkptr += size;
		dirptr++;
		dirindex++;
	}
	return(FIND_STAT_NOTFOUND);
}

ffs_find_file(filename, result)
	u_short *filename;
	struct find_file_results *result;
{
	int seg, fp;
	u_short firstlast;
	int stat, isfirst, islast;
	int total_size = 0;

	for (fp = 0, seg = FFS_MINSEG; seg <= FFS_MAXSEG; seg++) {
		stat = ffs_find_fragment((caddr_t)FLASH_BASE +
			seg * FLASH_ERASEBLK_SIZE, filename,
			result->frags + fp, &firstlast);
		if (stat < 0)
			return(stat);
		if (!stat)
			continue;
		total_size += result->frags[fp].nblks;
		isfirst = (firstlast & RT11FFS_DIRENT_FIRST) != 0;
		islast = (firstlast & RT11FFS_DIRENT_LAST) != 0;
		if (isfirst != !fp)
			return(FIND_STAT_INVALID_FRAG);
		fp++;
		if (islast) {
			result->nfrags = fp;
			result->total_size = total_size;
			return(FIND_STAT_FOUND);
		}
	}
	return(fp ? FIND_STAT_INVALID_FRAG : FIND_STAT_NOTFOUND);
}
