/*
 * Linkage for applications using FLASHW
 */

#include "types.h"
#include "stdio.h"
#include "rt11ffs.h"
#include "monitor_api.h"
#include "../flashw/api.h"

static const u_short flashw_filename[3] __attribute__ ((section (".rodata")))
	= {0x2761, 0x7817, 0x0DF6};

struct flashw_api_table *
fetch_flashw()
{
	struct program_header *hdr;
	struct flashw_api_table *apitab;

	if (monapi_ffsload(flashw_filename, 0) < 0) {
		/* error message already printed */
		return(0);
	}
	hdr = (struct program_header *) monapi_getloadaddr();
	apitab = (struct flashw_api_table *) hdr->api_table_ptr;
	if (!apitab) {
		printf("Error: FLASHW.BIN has no valid API table\r\n");
		return(0);
	}
	/* FLASHW has no signature or ABI version #, so assume it's OK */
	return(apitab);
}
