#include "types.h"
#include "stdio.h"
#include "../include/mc68302.h"

extern char _printf_buffers[4][128];
extern u_short _printf_curbd;
extern volatile struct mc68302_scc_bd scc3_tx_bds[4];

void
putchar(c)
	int c;
{
	register int i;

	_printf_wait_for_bd();
	i = _printf_curbd;
	_printf_buffers[i][0] = c;
	scc3_tx_bds[i].bd_len = 1;
	scc3_tx_bds[i].bd_flags |= 0x8000;
	i += 1;
	if (i >= 4)
		i = 0;
	_printf_curbd = i;
}
