#include "types.h"
#include "stdio.h"
#include "../include/mc68302.h"

extern volatile struct mc68302_scc_bd scc3_rx_bds[8];
extern volatile u_char _getchar_buffer[8];
extern u_short _getchar_headptr;

int
getchar_poll()
{
	int i, c, bad;
	u_short flags;

	i = _getchar_headptr;
	flags = scc3_rx_bds[i].bd_flags;
	if (flags & 0x8000)
		return(EOF);
	c = _getchar_buffer[i];
	bad = (flags & 0x0030) || (scc3_rx_bds[i].bd_len < 1);
	scc3_rx_bds[i].bd_flags = flags & 0x7000 | 0x8000;
	i++;
	if (i >= 8)
		i = 0;
	_getchar_headptr = i;
	return bad ? EOF : c;
}
