#include "../libc/types.h"
#include "typedefs.h"
#include "config.h"
#include "bitpump.h"
#include "util.h"
#include "bpstate.h"

#define PLL_STABILIZE_DELAY     200

#define SYM_RATE_BT8960(symbol_rate) \
if ( symbol_rate <= 27 ) /* 0kHz - 110kHz */\
    BP_WRITE_BIT(bp_mode_ptr, pll_modes, clk_freq, TWO_CHANNEL_60);\
    else if ( symbol_rate <= 43 ) /* 110kHz - 176kHz */\
        BP_WRITE_BIT(bp_mode_ptr, pll_modes, clk_freq, FOUR_CHANNEL_60);\
        else if ( symbol_rate <= 59 ) /* 176kHz - 242kHz */\
            BP_WRITE_BIT(bp_mode_ptr, pll_modes, clk_freq, SIX_CHANNEL_60);\
            else /* Above 242kHz */\
                BP_WRITE_BIT(bp_mode_ptr, pll_modes, clk_freq, EIGHT_CHANNEL_60);

#define SYM_RATE_BT8970(symbol_rate) \
if (symbol_rate <= 80) /* 0KHz - 328KHz */\
    BP_WRITE_BIT(bp_mode_ptr, pll_modes, clk_freq, EIGHT_CHANNEL_70);\
    else if (symbol_rate <= 118) /* 328KHz - 484KHz */\
        BP_WRITE_BIT(bp_mode_ptr, pll_modes, clk_freq, HALF_T1_70);\
        else if ( symbol_rate <= 167 ) /* 484KHz - 684KHz */\
            BP_WRITE_BIT(bp_mode_ptr, pll_modes, clk_freq, FULL_T1_70);   /* was HALF_E1_70 */\
            else /* Above 684KHz */\
                BP_WRITE_BIT(bp_mode_ptr, pll_modes, clk_freq, FULL_T1_70);

#define SYM_RATE_BT8973(symbol_rate) \
    BP_WRITE_BIT(bp_mode_ptr, pll_modes, clk_freq, (symbol_rate & 0x300) >> 8 );\
    BP_WRITE_REG(bp_ptr, clock_freq, (symbol_rate & 0xFF) );

set_bitpump_clock()
{
    DECLARE_PTR;
    DECLARE_MODE_PTR;

    switch (GET_BITPUMP_TYPE()) {
#if SUPPORT_BT8960
    case BT8960:
        SYM_RATE_BT8960(BP_global_state.symbol_rate);
	break;
#endif
#if SUPPORT_BT8970
    case BT8970:
	icd2053_set_clock(BP_global_state.symbol_rate * 8);
        SYM_RATE_BT8970(BP_global_state.symbol_rate);
	break;
#endif
#if SUPPORT_RS8973
    case RS8973:
        SYM_RATE_BT8973(BP_global_state.symbol_rate);
#endif
    }
    cpu_delay_us(PLL_STABILIZE_DELAY);
}
