#include "typedefs.h"
#include "config.h"
#include "bitpump.h"
#include "util.h"

/*---------------------------------------------------------*/
/*  Local Defines                                          */
/*---------------------------------------------------------*/

#define CHECK_VALUE      0xAAAA
#define CHECK_BYTE_VALUE   0xAA
#define N_CHECK_VALUE    0x5555
#define N_CHECK_BYTE_VALUE 0x55

/***********************************************************/
/*    _SelfTest()                                          */
/*    Run Bitpump self test.                               */
/*    This is also the place where we check the bitpump    */
/*    type and make sure we support it.			   */
/*                                                         */
/*    returns: 0 for pass, -1 for fail                     */
/*                                                         */
/*    Input variables: BP_U_8BIT no                        */
/*                                                         */
/*    Output variables: None                               */
/*                                                         */
/*    example:                                             */
/*           status = _SelfTest(no);                       */
/*                                                         */
/* Programmer:                                             */
/*     Iris Shuker                                         */
/*                                                         */
/* revision history:                                       */
/*                                                         */
/***********************************************************/

_SelfTest (BP_U_8BIT no)
{
    DECLARE_PTR;
    DECLARE_MODE_PTR;
    BP_U_8BIT data[4];

    /*-------------------------------------------------------------------*/
    /* _SelfTest routine tests Bitpump.                                  */
    /*-------------------------------------------------------------------*/
    BP_WRITE_REG(bp_ptr, linear_ec_modes, RESET);
    BP_WRITE_BIT(bp_mode_ptr, linear_ec_modes, adapt_coefficients, OFF); /* Freeze Linear EC */

    SET_WORD(bp_ptr, access_data_byte0, access_data_byte1, CHECK_VALUE);
    SET_WORD(bp_ptr, access_data_byte2, access_data_byte3, CHECK_VALUE);
    BP_WRITE_REG(bp_ptr, linear_ec_tap_select_write, 0);
    DELAY2SYMBOL;
    SET_WORD(bp_ptr, access_data_byte0, access_data_byte1, N_CHECK_VALUE);
    SET_WORD(bp_ptr, access_data_byte2, access_data_byte3, N_CHECK_VALUE);
    BP_WRITE_REG(bp_ptr, linear_ec_tap_select_read, 0);
    DELAY2SYMBOL;

    bp_lec_read(0, data);
    if ( data[0] != CHECK_BYTE_VALUE )
        {
        if (data[0] == N_CHECK_BYTE_VALUE)
            printf("RAM present instead of Bitpump\r\n");
        else
            printf("Bitpump not present\r\n");
        return(-1);
        }

    if (data[1] != CHECK_BYTE_VALUE) {
bad:	printf("Bitpump is bad\r\n");
        return(-1);
    }
    if (data[2] != CHECK_BYTE_VALUE)
        goto bad;
    if (data[3] != CHECK_BYTE_VALUE)
        goto bad;

    BP_WRITE_BIT(bp_mode_ptr, linear_ec_modes, adapt_coefficients, OFF);
    SET_RESET(bp_mode_ptr, linear_ec_modes, zero_coefficients);

    bp_lec_read(0, data);
    if (data[0] != 0)
        goto bad;
    if (data[1] != 0)
        goto bad;
    if (data[2] != 0)
        goto bad;
    if (data[3] != 0)
        goto bad;

    switch (GET_BITPUMP_TYPE()) {
    case BT8960:
#if SUPPORT_BT8960
	printf("Found Bt8960 bitpump\r\n");
	break;
#else
	printf("Bt8960 bitpump not supported!\r\n");
	return(-1);
#endif
    case BT8970:
#if SUPPORT_BT8970
	printf("Found Bt8970 bitpump\r\n");
	break;
#else
	printf("Bt8970 bitpump not supported!\r\n");
	return(-1);
#endif
    case RS8973:
#if SUPPORT_RS8973
	printf("Found RS8973 bitpump\r\n");
	break;
#else
	printf("RS8973 bitpump not supported!\r\n");
	return(-1);
#endif
    default:
	printf("Unsupported bitpump type\r\n");
	return(-1);
    }
    printf("Bitpump self-test passed\r\n");
    return(0);

} /* end _SelfTest() */
