#include "../libc/types.h"
#include "typedefs.h"
#include "config.h"
#include "bitpump.h"
#include "util.h"
#include "readmeter.h"

u_short
bp_read_meter(dummy, id)
{
	DECLARE_PTR;
	DECLARE_MODE_PTR;
	int nf;
	u_short retval;

	switch (id) {
	case READMETER_SLM_NORM:
	case READMETER_DC_NORM:
	case READMETER_FELM_NORM:
	case READMETER_NLM_NORM:
		nf = _NormlizeMeter();
		break;
	default:
		nf = 0;
	}

	switch (id) {
	case READMETER_SLM_RAW:
	case READMETER_SLM_NORM:
		READ_METER_REG(slm_low, slm_high, retval, nf);
		break;
	case READMETER_DC_RAW:
	case READMETER_DC_NORM:
		READ_METER_REG(dc_meter_low, dc_meter_high, retval, nf);
		break;
	case READMETER_FELM_RAW:
	case READMETER_FELM_NORM:
		READ_METER_REG(felm_low, felm_high, retval, nf);
		break;
	case READMETER_DCOFFSET:
		READ_METER_REG(dc_offset_low, dc_offset_high, retval, 0);
		break;
	case READMETER_PDM_RAW:
		READ_METER_REG(pdm_low, pdm_high, retval, 0);
		break;
	case READMETER_OVERFLOW:
		retval = bp_ptr->overflow_meter;
		break;
	case READMETER_NLM_RAW:
	case READMETER_NLM_NORM:
		READ_METER_REG(nlm_low, nlm_high, retval, nf);
		break;
	case READMETER_BER:
		READ_METER_REG(ber_meter_low, ber_meter_high, retval, 0);
		break;
	case READMETER_VCXO:
		READ_METER_REG(vcxo_frequency_low, vcxo_frequency_high,
				retval, 0);
		break;
	case READMETER_INTERVAL:
		READ_METER_REG(meter_low, meter_high, retval, 0);
		break;
	case READMETER_AAGC:
		retval = bp_mode_ptr->adc_control.again;
		break;
	}

	return(retval);
}
