#include "../libc/types.h"
#include "typedefs.h"
#include "config.h"
#include "bitpump.h"
#include "util.h"
#include "bpstate.h"

bp_power_down()
{
	DECLARE_PTR;
	DECLARE_MODE_PTR;
	int s;

	s = splup(1);
	switch (GET_BITPUMP_TYPE()) {
#if SUPPORT_BT8970
	case BT8970:
		BP_global_state.symbol_rate = 20;	/* 160 kbps */
		set_bitpump_clock();
		break;
#endif
#if SUPPORT_RS8973
	case RS8973:
		BP_global_state.symbol_rate = 18;	/* 144 kbps */
		set_bitpump_clock();
		break;
#endif
	}
	printf("Putting bitpump into low power mode, BCLK @ %u kbps\r\n",
		BP_global_state.symbol_rate * 8);

        /* power down AFE section - middle 2 bits of 4-bit reserve field*/
        BP_WRITE_BIT(bp_mode_ptr, misc_test, reserved2, 0x6);

        BP_WRITE_REG(bp_ptr, mask_low_reg, 0xFF);
        BP_WRITE_REG(bp_ptr, mask_high_reg, 0xFF);

        BP_WRITE_BIT(bp_mode_ptr, global_modes, mode, _BITPUMP_POWER_DOWN);
	splx(s);
	return(0);
}
