/*
 * Bitpump microcode loading
 */

#include "typedefs.h"
#include "config.h"
#include "bitpump.h"
#include "util.h"

#define MICROCODE_LENGTH            64

/* Microcode */
static BP_S_32BIT BP_CONSTANT micro_code[MICROCODE_LENGTH] =
{0x79bbc23c,
0x87db80bc,
0x8997841c,
0xfff84014,
0x898fc60c,
0xfd470178,
0x897f060c,
0xfd350128,
0x896fc60c,
0xfd24c128,
0x895fc60c,
0xfd148128,
0x84ffc60c,
0xfd044128,
0x84efc60c,
0xfc740128,
0x84dfc60c,
0xfc61c0e4,
0x84cfc60c,
0xfc5180e0,
0x84bfc60c,
0xfc4140e0,
0x84afc60c,
0xfc3100e0,
0x849fc60c,
0xfc20c0e0,
0x848fc60c,
0xfc1080e0,
0x1cefc60c,
0xfc0040e0,
0x18d3c600,
0xfda000e0,
0x14c38600,
0xfdd68204,
0x10b34600,
0x87f7c200,
0x0ca30600,
0xfff84214,
0x0892c600,
0xffffc20c,
0x04828600,
0x73efc20c,
0x01c24600,
0xfff80218,
0x51820600,
0xffffc20c,
0x4d764600,
0xfff741b0,
0x49660600,
0xffffc20c,
0x4555c600,
0x87ffc20c,
0x42158600,
0xfff84214,
0x7a056600,
0xffffc20c,
0xffffc60c,
0xfdafc1f4,
0xfdbfc20c,
0xb2d6827c,
0xfff6c0ac,
0xffc89c0c,
0xfff8500c,
0xfff78a0c};


/***********************************************************/
/*    _BtLoadMicroCode()                                   */
/*    Program BrHomer micro-code                           */
/*                                                         */
/*    returns: void                                        */
/*                                                         */
/*    Input variables: BP_U_8BIT no                        */
/*                                                         */
/*    Output variables: None                               */
/*                                                         */
/*    example:                                             */
/*           _BtLoadMicroCode(no);                         */
/*                                                         */
/* Programmer:                                             */
/*     Iris Shuker                29-Oct-1993              */
/*                                                         */
/* revision history:                                       */
/*                                                         */
/***********************************************************/

_BtLoadMicroCode()
{
    DECLARE_PTR;
    int i;

#ifdef TDEBUG
    PREFIX;
    printf("Load MicroCode\r\n");
#endif

    for ( i = 0 ; i < MICROCODE_LENGTH ; i++ ) /* Write EQ micro code */
        {
        BP_WRITE_REG(bp_ptr, access_data_byte0, LOW(micro_code[i]));
        BP_WRITE_REG(bp_ptr, access_data_byte1, HIGH(micro_code[i]));
        BP_WRITE_REG(bp_ptr, access_data_byte2, HIGHER(micro_code[i]));
        BP_WRITE_REG(bp_ptr, access_data_byte3, HIGHEST(micro_code[i]));
        BP_WRITE_REG(bp_ptr, eq_microcode_add_write, i);
        DELAY2SYMBOL;
        } /* END-FOR write EQ micro code */

} /* END _BtLoadMicroCode() */
