/*
 * This bitpump interrupt handler is intended to be "global"
 * and independent of any particular application.
 */

#include "../libc/types.h"
#include "typedefs.h"
#include "config.h"
#include "bitpump.h"
#include "util.h"
#include "bpstate.h"

void
bp_interrupt_handler()
{
	DECLARE_PTR;
	struct bpstate *state = &BP_global_state;
	u_char actirq;

	actirq = bp_ptr->timer_source & ~bp_ptr->mask_low_reg;
	bp_ptr->timer_source = ~actirq;
	state->latched_timer_irq |= actirq;

	if (actirq & TIMERMASK_METER) {
		if (state->meter_tmr_inthandler)
		 state->meter_tmr_inthandler(state->meter_tmr_inthandler_param);
		state->meter_int_count++;
	}

	if (actirq & TIMERMASK_SNR && state->snr_tmr_inthandler)
		state->snr_tmr_inthandler(state->snr_tmr_inthandler_param);
	if (actirq & TIMERMASK_T3 && state->t3_inthandler)
		state->t3_inthandler(state->t3_inthandler_param);
	if (actirq & TIMERMASK_T4 && state->t4_inthandler)
		state->t4_inthandler(state->t4_inthandler_param);

	if (actirq & TIMERMASK_SUT1 && state->sut1_inthandler)
		state->sut1_inthandler(state->sut1_inthandler_param);
	if (actirq & TIMERMASK_SUT2 && state->sut2_inthandler)
		state->sut2_inthandler(state->sut2_inthandler_param);
	if (actirq & TIMERMASK_SUT3 && state->sut3_inthandler)
		state->sut3_inthandler(state->sut3_inthandler_param);
	if (actirq & TIMERMASK_SUT4 && state->sut4_inthandler)
		state->sut4_inthandler(state->sut4_inthandler_param);

	actirq = bp_ptr->irq_source & ~bp_ptr->mask_high_reg;
	bp_ptr->mask_high_reg |= actirq;
	state->latched_alarm_irq |= actirq;

	if (actirq & IRQMASK_LOWSNR && state->lowsnr_inthandler)
		state->lowsnr_inthandler(state->lowsnr_inthandler_param);
	if (actirq & IRQMASK_LOWFELM && state->lowfelm_inthandler)
		state->lowfelm_inthandler(state->lowfelm_inthandler_param);
	if (actirq & IRQMASK_HIGHFELM && state->highfelm_inthandler)
		state->highfelm_inthandler(state->highfelm_inthandler_param);
	if (actirq & IRQMASK_SYNC && state->sync_inthandler)
		state->sync_inthandler(state->sync_inthandler_param);
}
