/*
 * The famous _BtReset() function lives here
 */

#include "../libc/types.h"
#include "typedefs.h"
#include "config.h"
#include "bitpump.h"
#include "util.h"
#include "defmeter.h"
#include "bpstate.h"

#define WRITE_REG_35(a,b,c) \
    BP_WRITE_REG(bp_ptr, test_reg35, a);\
    BP_WRITE_REG(bp_ptr, test_reg35, b);\
    BP_WRITE_REG(bp_ptr, test_reg35, c);\
    DELAY2SYMBOL;

/***********************************************************/
/*    _BtReset()                                           */
/*    Reset Bitpump to default setup, load micro-code.     */
/*                                                         */
/*    returns: void                                        */
/*                                                         */
/*    Input variables: BP_U_8BIT no                        */
/*                                                         */
/*    Output variables: None                               */
/*                                                         */
/*    example:                                             */
/*           _BtReset(no);                                 */
/*                                                         */
/* Programmer:                                             */
/*     Iris Shuker                24-Oct-1993              */
/*                                                         */
/* revision history:                                       */
/*                                                         */
/***********************************************************/

void _BtReset (BP_U_8BIT no)
{
    DECLARE_PTR;
    DECLARE_MODE_PTR;
    int s;

#ifdef TDEBUG
    PREFIX;
    printf("Resetting bitpump at %d kbps\r\n", BP_global_state.symbol_rate * 8);
#endif

    s = splup(1);
    /* power UP */
    BP_WRITE_BIT(bp_mode_ptr, global_modes, mode, _BITPUMP_POWER_UP);
    /* power up AFE section - middle 2 bits of 4-bit reserve field*/
    BP_WRITE_BIT(bp_mode_ptr, misc_test, reserved2, 0x0);

    /*------------------------------------------------*/
    /* Reset All Bitpump registers to default values  */
    /*------------------------------------------------*/
    BP_WRITE_BIT(bp_mode_ptr, serial_monitor_source, hclk_freq, _HCLK_DEFAULT);

    BP_WRITE_BIT(bp_mode_ptr, pll_modes, freeze_pll, ON);

    set_bitpump_clock();
    _BtLoadMicroCode(no);

    BP_WRITE_REG(bp_ptr, adc_control, RESET); /* Reset ADC Gain Control register, default value: fixed gain, no AGC */

    switch (GET_BITPUMP_TYPE()) {
#if SUPPORT_BT8960
    case BT8960:
        BP_WRITE_REG(bp_ptr, clock_freq, 0xC0);  /* 'reserved10' for Bt8960 */
        BP_WRITE_REG(bp_ptr, test_reg35, 0x60);
	break;
#endif
#if SUPPORT_BT8970
    case BT8970:
        WRITE_REG_35(0x00, 0x43, 0x00);
        BP_WRITE_REG(bp_ptr, clock_freq, 0x0C);  /* 'reserved10' for Bt8970 */
	break;
#endif
#if SUPPORT_RS8973
    case RS8973:
        /* Bt8973 */
        /*-------------------------------------*/
        /* Pulse Shaping Filter (Bt8973 Only)  */
        /*-------------------------------------*/

        if ( BP_global_state.symbol_rate <= 50 )
         {
         if (BP_READ_BIT(bp_mode_ptr, global_modes,hw_revision) >=0x02)
            {
            BP_WRITE_BIT(bp_mode_ptr, adc_control, cont_time, _400K_FILTER);
            }
         else
            {
            BP_WRITE_BIT(bp_mode_ptr, adc_control, cont_time, _784K_FILTER);
            }
         BP_WRITE_BIT(bp_mode_ptr, adc_control, switch_cap_pole, 0);
         BP_WRITE_BIT(bp_mode_ptr, receive_phase_select, imp_short, 0);
         }
        else if ( BP_global_state.symbol_rate < 100 )
            { /* Less than 800kbps */\
            BP_WRITE_BIT(bp_mode_ptr, adc_control, cont_time, _784K_FILTER);
            BP_WRITE_BIT(bp_mode_ptr, adc_control, switch_cap_pole, 0);
            BP_WRITE_BIT(bp_mode_ptr, receive_phase_select, imp_short, 0);
            }
        else if ( BP_global_state.symbol_rate < 150 )
            { /* 800KHz - 1200KHz */
            BP_WRITE_BIT(bp_mode_ptr, adc_control, cont_time, _1168K_FILTER);
            BP_WRITE_BIT(bp_mode_ptr, adc_control, switch_cap_pole, 0);
            BP_WRITE_BIT(bp_mode_ptr, receive_phase_select, imp_short, 0);
            }
        else
            { /* Above 1200KHz */
            BP_WRITE_BIT(bp_mode_ptr, adc_control, cont_time, _2320K_FILTER);

            /* Turn on switched cap pole which works for RS8973, Rev. B and thereafter.
             * Switched cap pole does not work on Rev. A, see Non-conformance #2. 
             */
            if ( BP_READ_BIT(bp_mode_ptr, global_modes, hw_revision) != 0x00 )
                {
                BP_WRITE_BIT(bp_mode_ptr, adc_control, switch_cap_pole, 1);
                }
            BP_WRITE_BIT(bp_mode_ptr, receive_phase_select, imp_short, 0);
            }
     
        WRITE_REG_35(0x00, 0x42, 0x00);
#endif
    }     

    BP_WRITE_REG(bp_ptr, cu_interface_modes, _SERIAL_SIGNFIRST); /* Set CU Interface default value: Normal operationn and serial interface with clock outputs */

    BP_WRITE_BIT(bp_mode_ptr, tx_gain, tx_gain, get_txgain_default());

#if SUPPORT_BT8970
    /* This monkey business used to be in _InitTxGain() */
    if ( ( GET_BITPUMP_TYPE() == BT8970 ) &&
         ( BP_READ_BIT(bp_mode_ptr, global_modes, hw_revision) == 0x02 ) &&
         ( BP_READ_BIT(bp_mode_ptr, tx_calibrate, tx_gain) == 0 ) )
        {

        /*
         * Modification of band_gap value.  First set the band_gap value.
         * The value is 0x02 for all Bt8970 devices
         */ 
        BP_WRITE_BIT(bp_mode_ptr, tx_gain, band_gap_high, 0x00);
        BP_WRITE_BIT(bp_mode_ptr, tx_gain, band_gap_low,  0x02);
        
        /*
         * Second, change the default value of band_gap_test_mode to 1.
         * This bit controls which register sets the band_gap
         * (if 1, then tx_gain, else tx_calibrate)
         */ 
        BP_WRITE_BIT(bp_mode_ptr, misc_test, band_gap_test_mode, ON); 
        }
#endif

    BP_WRITE_REG(bp_ptr, peak_detector_delay, PKD_DELAY_INIT_VALUE); /* Set peak detector delay */

    _BtInitialize(no);
    _SetMeterTimer(ALT_METER, HIGH_FELM_ALARM_TH, LOW_FELM_ALARM_TH);
    splx(s);

    /* clear out any old interrupt handlers */
    BP_global_state.sut1_inthandler = 0;
    BP_global_state.sut2_inthandler = 0;
    BP_global_state.sut3_inthandler = 0;
    BP_global_state.sut4_inthandler = 0;
    BP_global_state.meter_tmr_inthandler = 0;
    BP_global_state.snr_tmr_inthandler = 0;
    BP_global_state.t3_inthandler = 0;
    BP_global_state.t4_inthandler = 0;
    BP_global_state.lowsnr_inthandler = 0;
    BP_global_state.lowfelm_inthandler = 0;
    BP_global_state.highfelm_inthandler = 0;
    BP_global_state.sync_inthandler = 0;
    BP_global_state.meter_int_count = 0;

} /* END _BtReset() */
