/*
 * Our implementation of the BER meter works as follows:
 *
 * 1. The user allocates a struct ber_meter_state data structure.
 * 2. ber_meter_inthandler() needs to be installed as the meter
 *    interrupt handler in BP_global_state with the pointer to
 *    struct ber_meter_state as the parameter.
 * 3. The interrupt handler will now do the counting, incrementing
 *    the tally counters in the state structure.
 */

#include "../libc/types.h"
#include "typedefs.h"
#include "bitpump.h"
#include "util.h"
#include "bermeter.h"

void
ber_meter_inthandler(state)
	struct	ber_meter_state *state;
{
	DECLARE_PTR;
	BP_U_8BIT temp;

	temp = BP_READ_REG(bp_ptr, ber_meter_low);
	state->bit_errors +=
			BYTE2WORD(BP_READ_REG(bp_ptr, ber_meter_high), temp);
	state->meter_intervals++;
}
