/*
 * "Arbitrary" version of _SetMeterTimer()
 */

#include "../libc/types.h"
#include "typedefs.h"
#include "config.h"
#include "bitpump.h"
#include "util.h"
#include "bpstate.h"

void
_SetMeterArbitrary(value)
	u_short value;
{
    DECLARE_PTR;
    DECLARE_MODE_PTR;
    int s;

    BP_WRITE_BIT(bp_mode_ptr, mask_high_reg, low_felm, ON); /* Mask low FELM int. */
    BP_WRITE_BIT(bp_mode_ptr, mask_high_reg, high_felm, ON); /* Mask high FELM int. */

    SET_WORD(bp_ptr, meter_low, meter_high, value);

    s = splup(1);
    bp_ptr->timer_source = ~TIMERMASK_METER;
    BP_global_state.latched_timer_irq &= ~TIMERMASK_METER;
    BP_WRITE_BIT(bp_mode_ptr, timer_restart, meter, ON);
    splx(s);

}
