/*---------------------------------------------------------*/
/*  Analog test state machine                              */
/*---------------------------------------------------------*/

/* Test Mode Stages */
#define TEST_MODE_IDLE           0
#define TM_WAIT_METER_INTERVAL1  1
#define TM_WAIT_METER_INTERVAL2  2

/* Analog Loop back stages */
#define TM_ALB_INITIALIZE        10
#define TM_ALB_ACTIVATE          11
#define TM_ALB_ADAPT_EC          12
#define TM_ALB_ADAPT_DAGC        13
#define TM_ALB_OPEN_EYE1         14
#define TM_ALB_OPEN_EYE2         15
#define TM_ALB_OPEN_EYE3         16
#define TM_ALB_OPEN_EYE4         17
#define TM_ALB_OPEN_EYE5         18
#define TM_ALB_TX_4LEVEL         19
                      
/* ERLE stages */
#define TM_ERLE_INIT             30
#define TM_ERLE_DC_CANCEL        31
#define TM_ERLE_ADAPT_EC1        32
#define TM_ERLE_ADAPT_EC2        33
#define TM_ERLE_ADAPT_EC3        34
#define TM_ERLE_BYPASS_NLEC      35
#define TM_ERLE_ADAPT_NLEC1      36
#define TM_ERLE_ADAPT_NLEC2      37
#define TM_ERLE_ADAPT_NLEC3      38
#define TM_ERLE_MEASURE          39
#define TM_AERLE_MEASURE         40

/* Measure AAGC stage */
#define TM_AAGC_INIT             50
#define TM_AAGC_DC_CANCEL        51      
#define TM_AAGC_MEASURE          52   


/*---------------------------------------------------------*/
/*  TYPEDEF Defines                                        */
/*---------------------------------------------------------*/

typedef struct
{
    BP_BIT_FIELD transmit_state:1;
    BP_BIT_FIELD symbol_rate:2;
    BP_BIT_FIELD again:3;
    BP_BIT_FIELD transmit_level:1;
    BP_BIT_FIELD nl_ec:1;
}ERLE_MODE_BITS;

typedef union{
    BP_U_8BIT erle;
    ERLE_MODE_BITS bits;
}ERLE_MODE;

struct analogtests_state {
	u_char	stage;
	u_char	stage2;
	u_char	albtype;
	ERLE_MODE	erlemode;
	u_char	status;
};

#define	TM_STATUS_INPROGRESS	0x00
#define	TM_STATUS_SUCCESS	0x01
#define	TM_STATUS_FAILED	0x02
#define	TM_STATUS_TIMEOUT	0x03
