/*
 * Generic buffer management code
 */

#include "types.h"
#include "bufmac.h"
#include "param.h"

struct buffer *buf_freelist;

init_buf_freelist()
{
	struct buffer *buf;
	int i;

	buf = (struct buffer *)BUFBASE;
	buf_freelist = buf;
	for (i = 0; i < NBUFS-1; buf++, i++)
		buf->buf_next = buf + 1;
	buf->buf_next = 0;
	return(0);
}

struct buffer *
get_buffer()
{
	struct buffer *buf;
	int s;

	s = spl7();
	buf = buf_freelist;
	if (!buf) {
		printf("L2CONV BUG: out of buffers\r\n");
		asm("trap #0");
	}
	buf_freelist = buf->buf_next;
	splx(s);
	return(buf);
}

free_buffer(buf)
	struct buffer *buf;
{
	int s;

	s = spl7();
	buf->buf_next = buf_freelist;
	buf_freelist = buf;
	splx(s);
}
