/*
 * Definitions for the RT-11 Flash File System (Harhan/IFCTF)
 */

#ifndef __RT11FFS_H
#define	__RT11FFS_H

#include "flash.h"

#define	RT11FFS_AU_SIZE		0x200

#define	FFS_AUs_PER_SEGMENT	(FLASH_ERASEBLK_SIZE / RT11FFS_AU_SIZE)
#define	FFS_NSEGS		7
#define	FFS_MINSEG		1
#define	FFS_MAXSEG		7

struct rt11ffs_dirent {
	u_short	filename[3];
	u_short	size_flags;
};
/* masks for the last word */
#define	RT11FFS_DIRENT_VALID		0x8000
#define	RT11FFS_DIRENT_FIRST		0x4000
#define	RT11FFS_DIRENT_LAST		0x2000
#define	RT11FFS_DIRENT_SIZEMASK		0x1FFF

/* header structure for RUN-able programs */
struct program_header {
	u_long	magic;
	u_long	loadaddr;
	u_long	entry_point;		/* absolute address on this arch */
	caddr_t	api_table_ptr;
};
#define	RUNABLE_PROGRAM_MAGIC		0x52503638

#endif
