#ifndef __NOKIA_H
#define	__NOKIA_H

/*
 * Nokia SDSL frame format
 */

#include "atm.h"

/* This is what we now believe to be the true canonical format of the frame */
struct nokia_frame_can {
	u_char	sync_octet;
	struct	atmcell cells[8];
	u_char	rsvd1;
	u_char	eoc;
	u_char	rsvd2[4];
	u_char	crc6;
};

#define	NOKIA_SYNC_OCTET	0xE4

/*
 * When we use the MC68x302 SCC to receive and transmit these frames,
 * they end up looking like this:
 */
struct nokia_frame_scc {
	struct	atmcell cells[8];
	u_char	hdrbytes[8];
};

/*
 * We tell the SCC to sync on E4 00, i.e., we have to rely on
 * the first octet of the first ATM cell header being 00
 * in order to get the SCC to sync initially.
 *
 * As we've also learned experimentally, the sync word has
 * to be programmed in DSR bit-reversed.
 */
#define	NOKIA_SCC_SYNC_WORD	0x0027

#endif	/* __NOKIA_H */
