/*
 * This minimal API is exported by the base monitor to the other
 * utility programs found in this code tree.
 */

struct monitor_api_table {
	int	(*ffs_find_file)();
	int	(*ffs_find_file_wrapper)();
	int	(*load_from_ffs)();
	u_long	(*get_load_addr)();
	int	(*ffs_scan_flash)();
	int	(*check_intr)();
	void	(*error)();
	void	(*stop_cmd_script)();
	void	(*reset)();
	int	(*help)();
};

extern struct monitor_api_table *monitor_api_table_ptr;

#define	monapi_ffsfind		monitor_api_table_ptr->ffs_find_file
#define	monapi_ffsfindwrap	monitor_api_table_ptr->ffs_find_file_wrapper
#define	monapi_ffsload		monitor_api_table_ptr->load_from_ffs
#define	monapi_getloadaddr	monitor_api_table_ptr->get_load_addr
#define	monapi_scanffs		monitor_api_table_ptr->ffs_scan_flash
#define	monapi_checkintr	monitor_api_table_ptr->check_intr
#define	monapi_error		monitor_api_table_ptr->error
#define	monapi_stopscripts	monitor_api_table_ptr->stop_cmd_script
#define	monapi_reset		monitor_api_table_ptr->reset
#define	monapi_help		monitor_api_table_ptr->help
