/*
 * This header file provides #defines for the absolute addresses of various
 * MC68302 registers for assembly code.
 */

#define	BAR	0x0000F2
#define	SCR	0x0000F4
#define	CKCR	0x0000FA

/* IDMA */
#define	CMR	0x700802
#define	SAPR	0x700804
#define	DAPR	0x700808
#define	BCR	0x70080C
#define	CSR	0x70080E
#define	FCR	0x700810
/* interrupt controller */
#define	GIMR	0x700812
#define	IPR	0x700814
#define	IMR	0x700816
#define	ISR	0x700818
/* PIO */
#define	PACNT	0x70081E
#define	PADDR	0x700820
#define	PADAT	0x700822
#define	PBCNT	0x700824
#define	PBDDR	0x700826
#define	PBDAT	0x700828
/* chip selects */
#define	BR0	0x700830
#define	OR0	0x700832
#define	BR1	0x700834
#define	OR1	0x700836
#define	BR2	0x700838
#define	OR2	0x70083A
#define	BR3	0x70083C
#define	OR3	0x70083E
/* timers */
#define	TMR1	0x700840
#define	TRR1	0x700842
#define	TCR1	0x700844
#define	TCN1	0x700846
#define	TER1	0x700849
#define	WRR	0x70084A
#define	WCN	0x70084C
#define	TMR2	0x700850
#define	TRR2	0x700852
#define	TCR2	0x700854
#define	TCN2	0x700856
#define	TER2	0x700859
/* just a few of the CP registers */
#define	CR	0x700860
#define	SCON1	0x700882
#define	SCM1	0x700884
#define	SCON2	0x700892
#define	SCM2	0x700894
#define	SCON3	0x7008A2
#define	SCM3	0x7008A4
#define	SPMODE	0x7008B0
#define	SIMASK	0x7008B2
#define	SIMODE	0x7008B4
