/*
 * This header file defines the interrupt vector numbers and IMR/IPR/ISR masks
 * for all interrupt sources in the system.
 */

#define	INTVEC_ERROR	0x40
#define	INTVEC_PB8	0x41
#define	INTVEC_SMC2	0x42
#define	INTVEC_SMC1	0x43
#define	INTVEC_TIMER3	0x44
#define	INTVEC_SCP	0x45
#define	INTVEC_TIMER2	0x46
#define	INTVEC_PB9	0x47
#define	INTVEC_SCC3	0x48
#define	INTVEC_TIMER1	0x49
#define	INTVEC_SCC2	0x4A
#define	INTVEC_IDMA	0x4B
#define	INTVEC_SDMAERR	0x4C
#define	INTVEC_SCC1	0x4D
#define	INTVEC_PB10	0x4E
#define	INTVEC_PB11	0x4F
#define	INTVEC_IRQ1	0x51
#define	INTVEC_IRQ6	0x56
#define	INTVEC_IRQ7	0x57

#define	INTMASK_PB11	0x8000
#define	INTMASK_PB10	0x4000
#define	INTMASK_SCC1	0x2000
#define	INTMASK_SDMAERR	0x1000
#define	INTMASK_IDMA	0x0800
#define	INTMASK_SCC2	0x0400
#define	INTMASK_TIMER1	0x0200
#define	INTMASK_SCC3	0x0100
#define	INTMASK_PB9	0x0080
#define	INTMASK_TIMER2	0x0040
#define	INTMASK_SCP	0x0020
#define	INTMASK_TIMER3	0x0010
#define	INTMASK_SMC1	0x0008
#define	INTMASK_SMC2	0x0004
#define	INTMASK_PB8	0x0002
#define	INTMASK_ERROR	0x0001
