/*
 * Some defines for the MC68302 CP
 */

#define	CPCOM_STOP_TX		0
#define	CPCOM_RESTART_TX	1
#define	CPCOM_ENTER_HUNT	2

#define	CR_SCC1		0
#define	CR_SCC2		1
#define	CR_SCC3		2

/* SCM bits */
#define	SCM_DIAG		0x0030
#define	SCM_NORMAL_CTS_CD	0x0000
#define	SCM_LOOPBACK		0x0010
#define	SCM_ECHO		0x0020
#define	SCM_SOFT_CTS_CD		0x0030
#define	SCM_ENR			0x0008
#define	SCM_ENT			0x0004
#define	SCM_MODE		0x0003
#define	SCM_MODE_HDLC		0x0000
#define	SCM_MODE_ASYNC		0x0001
#define	SCM_MODE_DDCMP_V110	0x0002
#define	SCM_MODE_BISYNC		0x0003

/* HDLC specifics */
#define	SCM_HDLC_NOF		0xF000
#define	SCM_HDLC_C32		0x0800
#define	SCM_HDLC_FSE		0x0400
#define	SCM_HDLC_RTE		0x0100
#define	SCM_HDLC_FLG		0x0080
#define	SCM_HDLC_NRZI		0x0040

/* UART specifics */
#define	SCM_UART_TPM		0xC000
#define	SCM_UART_RPM		0x2000
#define	SCM_UART_PEN		0x1000
#define	SCM_UART_UM		0x0C00
#define	SCM_UART_FRZ		0x0200
#define	SCM_UART_CL		0x0100
#define	SCM_UART_RTSM		0x0080
#define	SCM_UART_SL		0x0040

/* BISYNC specifics */
#define	SCM_BISYNC_PM		0x8000
#define	SCM_BISYNC_EXSYN	0x4000
#define	SCM_BISYNC_NTSYN	0x2000
#define	SCM_BISYNC_REVD		0x1000
#define	SCM_BISYNC_BCS		0x0800
#define	SCM_BISYNC_RTR		0x0200
#define	SCM_BISYNC_RBCS		0x0100
#define	SCM_BISYNC_SYNF		0x0080
#define	SCM_BISYNC_NRZI		0x0040
