/*
 * Miscellaneos C routines for the RAM monitor
 */

#include "types.h"
#include "stdio.h"
#include "mc68302.h"
#include "intr.h"
#include "buserr.h"

extern caddr_t m68000_vectors[];
extern volatile struct mc68302_regs mc68302_regs;

extern char _Xvec_buserr;
extern char _Xvec_address;
extern char _Xvec_generic;
extern char _Xvec_rte;

init_vectors()
{
	int i;

	m68000_vectors[2] = &_Xvec_buserr;
	m68000_vectors[3] = &_Xvec_address;
	for (i = 4; i < 60; i++)
		m68000_vectors[i] = &_Xvec_generic;
	for (i = 64; i < 256; i++)
		m68000_vectors[i] = &_Xvec_generic;
	m68000_vectors[INTVEC_ERROR] = &_Xvec_rte;
	mc68302_regs.imr = 0;
}

print_buserr_frame(frame)
	struct buserr_frame *frame;
{
	printf("PC=%08X  SR=%04X  IR=%04X\r\nAccess: %04X %08X\r\n", frame->pc,
		frame->sr, frame->ir, frame->acc_details, frame->acc_addr);
}
