/*
 * Actual flash erase and program operations
 */

#include "types.h"
#include "stdio.h"
#include "flash.h"
#include "errors.h"

#define	FLASH_MAGIC1	((volatile u_short *) 0x20AAAA)
#define	FLASH_MAGIC2	((volatile u_short *) 0x205554)

flash_erase(sectormask)
{
	int i, s, stat;
	u_short *sptr, *act_sptr = NULL;

	s = spl7();
	for (i = 0, sptr = (u_short *)FLASH_BASE; i < FLASH_NBLOCKS;
	     i++, sptr += FLASH_ERASEBLK_SIZE/2)
		if (sectormask & (1 << i)) {
			if (!act_sptr) {
				act_sptr = sptr;
				*FLASH_MAGIC1 = 0xAAAA;
				*FLASH_MAGIC2 = 0x5555;
				*FLASH_MAGIC1 = 0x8080;
				*FLASH_MAGIC1 = 0xAAAA;
				*FLASH_MAGIC2 = 0x5555;
			}
			*(volatile u_short *)sptr = 0x3030;
		}
	stat = flash_wait_compl(act_sptr, 0xFFFF);
	if (stat)
		return(stat);
	splx(s);
	return(0);
}

flash_program(src, dst, len)
	caddr_t src, dst;
	int len;
{
	u_short *srcp, *dstp;
	int stat, s;

	for (srcp = (u_short *)src, dstp = (u_short *)dst; len;
	     srcp++, dstp++, len -= 2) {
		s = spl7();
		*FLASH_MAGIC1 = 0xAAAA;
		*FLASH_MAGIC2 = 0x5555;
		*FLASH_MAGIC1 = 0xA0A0;
		*(volatile u_short *)dstp = *srcp;
		stat = flash_wait_compl(dstp, *srcp);
		if (stat)
			return(stat);
		splx(s);
	}
	return(0);
}

flash_wait_compl(wptr, wrdata)
	u_short *wptr, wrdata;
{
	if (flash_wait_for_chip((u_char *)wptr, wrdata >> 8) < 0) {
		error("Flash write failed, even chip");
		return(FLASHWR_ERR_HW);
	}
	if (flash_wait_for_chip((u_char *)wptr + 1, wrdata & 0xFF) < 0) {
		error("Flash write failed, odd chip");
		return(FLASHWR_ERR_HW);
	}
	return(0);
}

flash_wait_for_chip(bptr, wrdatum)
	volatile u_char *bptr;
	u_char wrdatum;
{
	u_char rdbyte;
	int errcnt = 0;

	while (1) {
		rdbyte = *bptr;
		if ((rdbyte & 0x80) == (wrdatum & 0x80))
			return(0);
		if (rdbyte & 0x20)
			errcnt++;
		if (errcnt >= 2)
			return(-1);
	}
}

blank_check_region(start, len)
	caddr_t start;
	int len;
{
	u_char *cp;

	cp = (u_char *) start;
	while (len--)
		if (*cp++ != 0xFF)
			return(0);
	return(1);
}
