#include "types.h"
#include "stdio.h"
#include "ctype.h"
#include "strings.h"
#include "console.h"

extern int cmd_deposit();
extern int cmd_erase();
extern int cmd_examine();
extern int cmd_ffs();
extern int cmd_hexdump();
extern int cmd_program();
extern int cmd_x();
extern int reboot();

const struct keyword commands[] = {
	{"DEPOSIT", 1, (long) &cmd_deposit},
	{"ERASE", 2, (long) &cmd_erase},
	{"EXAMINE", 1, (long) &cmd_examine},
	{"FFS", 1, (long) &cmd_ffs},
	{"HEXDUMP", 1, (long) &cmd_hexdump},
	{"PROGRAM", 1, (long) &cmd_program},
	{"REBOOT", 1, (long) &reboot},
	{"X", 1, (long) &cmd_x},
	{NULL, 0, -1}};

console()
{
	char command[80];

	while (1) {
		char *cp;
		int count;

prompt:		printf("RAM>");
		for (cp = command, count = 0; ; ) {
			char ch;

			ch = toascii(getchar());
			switch (ch) {
			case '\0':	/* ignore NULs */
				continue;
			case 0x03:	/* ^C */
				printf("^C\r\n");
				goto prompt;
			case 0x08:	/* BS */
			case 0x7F:	/* DEL */
				if (!count)
					continue;
				printf("\b \b");
				cp--;
				count--;
				continue;
			case '\r':	/* CR */
				printf("\r\n");
				goto process_command;
			case 0x15:	/* ^U */
				printf("^U\r\n");
				goto prompt;
			}
			if (iscntrl(ch) || count == 79) {
				putchar(0x07);
				continue;
			}
			putchar(ch);
			*cp++ = ch;
			count++;
		}
process_command:
		*cp = '\0';
		/* Ignore comments */
		cp = index(command, '!');
		if (cp)
			*cp = '\0';
		for (cp = command; *cp == ' '; cp++)
			;
		if (!*cp)
			continue;
		exec_console_cmd(cp);
	}
}

exec_console_cmd(cmd)
	char *cmd;
{
	char *cp;
	int count;
	int (*cmdfunc)();
	int ambigcmd;

	if (!issym(*cmd)) {
		error("Illegal command");
		return(0);
	}
	for (cp = cmd, count = 0; issym(*cp); cp++)
		count++;
	ambigcmd = 0;
	cmdfunc = (int (*)()) find_keyword(cmd, count, commands, &ambigcmd);
	if ((long) cmdfunc != -1)
		return (*cmdfunc)(cp);
	else {
		if (ambigcmd)
			error("Ambiguous command");
		else
			error("Illegal command");
		return(0);
	}
}
