#include "types.h"
#include "stdio.h"
#include "ctype.h"
#include "strings.h"
#include "console.h"
#include "mc68302.h"
#include "cp.h"

extern volatile struct mc68302_regs mc68302_regs;
extern volatile struct mc68302_scc_bd scc3_rx_bds[8];
extern volatile struct mc68302_scc_uartparams scc3_params;

static u_char
cmd_x_chksum(start, count)
	u_char *start;
	int count;
{
	u_char *cp, *end;
	u_char accum = 0;

	for (cp = start, end = start + count; cp < end; cp++)
		accum += *cp;
	return(accum);
}

cmd_x(cmd)
	char *cmd;
{
	struct param params[2];
	u_long start, count;
	int chin;
	char *cp;
	u_char chksum;
	struct mc68302_scc_bd saved_rxbd0;
	u_char saved_rbdn;
	u_short status;

	if (parse_cmd(cmd, 2, 2, params, NULL, NULL, NULL))
		return(0);
	if (parse_hexnum(params[0].text, params[0].len, &start))
		return(0);
	if (parse_hexnum(params[1].text, params[1].len, &count))
		return(0);
	if (count & 0x80000000) {
		error("Binary unload not implemented");
		return(0);
	}
	if (count > 65534) {
		error("Cannot receive more than 65534 bytes");
		return(0);
	}
	chksum = 0;
	for (cp = cmd - 1; *cp; cp++)
		chksum += *cp;
	chin = getchar();
	chksum += chin;
	if (chksum) {
		error("Command checksum");
		return(0);
	}

	/* Reconfigure the SCC for bulk receive */
	mc68302_regs.scc3.scm &= ~SCM_ENR;
	send_cp_command(CR_SCC3, CPCOM_ENTER_HUNT);
	bcopy_words(scc3_rx_bds, &saved_rxbd0, sizeof(struct mc68302_scc_bd));
	saved_rbdn = scc3_params.rbdn;
	scc3_rx_bds[0].bd_flags = 0xE000;
	scc3_rx_bds[0].bd_bufptr = start;
	scc3_params.mrblr = count + 1;
	scc3_params.rbdn = 0;
	scc3_params.max_idl = 9600;
	mc68302_regs.scc3.scm |= SCM_ENR;
	/* tell the host we are ready */
	printf(">>>");

	/* now we just wait */
	while (scc3_rx_bds[0].bd_flags & 0x8000)
		;
	/* save the status and restore the SCC for getchar() */
	status = scc3_rx_bds[0].bd_flags;
	mc68302_regs.scc3.scm &= ~SCM_ENR;
	send_cp_command(CR_SCC3, CPCOM_ENTER_HUNT);
	bcopy_words(&saved_rxbd0, scc3_rx_bds, sizeof(struct mc68302_scc_bd));
	scc3_params.rbdn = saved_rbdn;
	scc3_params.mrblr = 1;
	scc3_params.max_idl = 1;
	mc68302_regs.scc3.scm |= SCM_ENR;
	printf("\r\n");

	/* how did it go? */
	if (status & 0x0030) {
		error("Serial receive error(s)");
		return(0);
	}
	if (status & 0x0002) {
		error("Serial receive overrun");
		return(0);
	}
	if (status & 0x0100) {
		error("Time out");
		return(0);
	}
	/* seems OK, verify the checksum */
	chksum = cmd_x_chksum(start, count + 1);
	if (chksum)
		error("Data checksum");
	return(0);
}
