#include "types.h"
#include "ctype.h"
#include "strings.h"
#include "stdio.h"
#include "logic.h"

extern struct promptlevel prompt_array[];
extern int promptlevel;

extern char *prompt();

extern int bitdsu_config_dtr();

stuc_ifctf_confirm()
{
	char *answer;
	int stat;

	printf("\r\nWhen configuring for the CO terminal (STU-C) role, this DSU\r\n");
	printf("configuration wizard will set the unit up to serve out our own\r\n");
	printf("IFCTF SDSL flavor.  It is our preferred flavor for times when one\r\n");
	printf("is in a position to choose.\r\n\r\n");
	printf("If instead you are seeking to emulate the flavor served out by some\r\n");
	printf("other DSLAM brand, you will need to create CONFIG.TXT manually.\r\n\r\n");
	printf("Press Enter to continue or type BACK to go back\r\n");
	answer = prompt();
	stat = check_std_responses(answer);
	if (stat)
		return(stat);
	return(ACTION_CONTINUE);
}

stuc_preact_fallback_count()
{
	char *answer;
	char *cfgptr;
	int stat, num;

	cfgptr = prompt_array[promptlevel].config_ptr;
loop:	printf("\r\nHow many times should pre-activation be retried before fallback (1-255)? ");
	answer = prompt();
	stat = check_std_responses(answer);
	if (stat)
		return(stat);
	if (!is_string_num(answer)) {
inv:		printf("Invalid entry\r\n");
		goto loop;
	}
	num = atoi(answer);
	if (num < 1 || num > 255)
		goto inv;
	cfgptr += sprintf(cfgptr, "preact_fallback=%d\n", num);
	prompt_array[promptlevel+1].func = bitdsu_config_dtr;
	prompt_array[promptlevel+1].config_ptr = cfgptr;
	return(ACTION_CONTINUE);
}

stuc_preact_fallback()
{
	char *answer;
	int stat;

loop:	printf("\r\nIFCTF SDSL pre-activation works by way of the STU-C transmitting\r\n");
	printf("a Hello message and waiting for a response from the STU-R.  If\r\n");
	printf("no STU-R response is heard, the STU-C can either retry or give up.\r\n\r\n");
	printf("You have the choice of configuring this function in one of 2 ways:\r\n\r\n");
	printf("1: Retry the IFCTF SDSL Hello message indefinitely until a valid\r\n");
	printf("   response is received.  This configuration allows faster startup\r\n");
	printf("   times if the STU-R requires pre-activation.\r\n\r\n");
	printf("2: Retry the IFCTF SDSL Hello message some fixed number of times,\r\n");
	printf("   then fall back to plain HTU-C startup.  This configuration will\r\n");
	printf("   result in a longer startup time if the STU-R requires pre-activation,\r\n");
	printf("   but it provides backward compatibility with STU-R devices that\r\n");
	printf("   don't understand such.\r\n\r\n");
	printf("Please make your selection (1 or 2): ");
	answer = prompt();
	stat = check_std_responses(answer);
	if (stat)
		return(stat);
	if (strlen(answer) != 1) {
inv:		printf("Invalid selection\r\n");
		goto loop;
	}
	switch (answer[0]) {
	case '1':
		prompt_array[promptlevel+1].func = bitdsu_config_dtr;
		prompt_array[promptlevel+1].config_ptr =
					prompt_array[promptlevel].config_ptr;
		return(ACTION_CONTINUE);
	case '2':
		prompt_array[promptlevel+1].func = stuc_preact_fallback_count;
		prompt_array[promptlevel+1].config_ptr =
					prompt_array[promptlevel].config_ptr;
		return(ACTION_CONTINUE);
	default:
		goto inv;
	}
}

stuc_preact()
{
	char *answer;
	char *cfgptr;
	int stat;

	cfgptr = prompt_array[promptlevel].config_ptr;
loop:	printf("\r\nYou have the choice of enabling or omitting the IFCTF SDSL\r\n");
	printf("pre-activation signal.  This signaling protocol allows the STU-C\r\n");
	printf("and STU-R to detect each other's presence prior to successful\r\n");
	printf("SDSL link establishment and allows the data rate in use to be\r\n");
	printf("communicated from the STU-C to the STU-R.\r\n\r\n");
	printf("If you are connecting two DSUs over a dry pair, we recommend\r\n");
	printf("that you enable pre-activation on the STU-C and configure the\r\n");
	printf("STU-R to listen for this pre-activation signal.  On the other\r\n");
	printf("hand, you may want to disable pre-activation if you are connecting\r\n");
	printf("to a legacy STU-R device like XSB-2000, Xpeed or Hack-o-Rocket\r\n");
	printf("which knows nothing about IFCTF SDSL pre-activation.\r\n\r\n");
	printf("Do you want to enable IFCTF SDSL pre-activation (Y/N)? ");
	answer = prompt();
	stat = check_std_responses(answer);
	if (stat)
		return(stat);
	switch (answer[0]) {
	case 'Y':
	case 'y':
		cfgptr += sprintf(cfgptr, "preact_type=IFCTF\n");
		prompt_array[promptlevel+1].func = stuc_preact_fallback;
		prompt_array[promptlevel+1].config_ptr = cfgptr;
		return(ACTION_CONTINUE);
	case 'N':
	case 'n':
		cfgptr += sprintf(cfgptr, "preact_type=none\n");
		prompt_array[promptlevel+1].func = bitdsu_config_dtr;
		prompt_array[promptlevel+1].config_ptr = cfgptr;
		return(ACTION_CONTINUE);
	default:
		printf("Invalid selection\r\n");
		goto loop;
	}
}

stuc_data_rate()
{
	char *answer;
	char *cfgptr;
	int stat, num;

loop:	cfgptr = prompt_array[promptlevel].config_ptr;
	printf("\r\nAs the CO terminal you get to dictate the data rate at which the\r\n");
	printf("SDSL circuit will run.  The RS8973 bitpump used in this DSU allows\r\n");
	printf("any rate between 144 and 2320 kbps in 8 kbps increments, but we\r\n");
	printf("encourage you to pick one of the standard rates:\r\n\r\n");
	printf("RS8973 preferred set: 144 272 400 528 784 1168 1552 2320\r\n");
	printf("Older classic rates:  160 288 416     784 1168 1568\r\n");
	printf("\r\nPlease enter the SDSL data rate in kbps: ");
	answer = prompt();
	stat = check_std_responses(answer);
	if (stat)
		return(stat);
	if (!is_string_num(answer)) {
		printf("Invalid entry\r\n");
		goto loop;
	}
	num = atoi(answer);
	if (num % 8 || num < 144 || num > 2320) {
		printf("Specified value is not a possible SDSL data rate\r\n");
		goto loop;
	}
	cfgptr += sprintf(cfgptr, "data_rate=%d\n", num);
	prompt_array[promptlevel+1].func = stuc_preact;
	prompt_array[promptlevel+1].config_ptr = cfgptr;
	switch (num) {
	case 144:
	case 160:
	case 192:
	case 208:
	case 272:
	case 288:
	case 320:
	case 384:
	case 392:
	case 400:
	case 416:
	case 528:
	case 768:
	case 784:
	case 1040:
	case 1152:
	case 1168:
	case 1536:
	case 1552:
	case 1568:
	case 2320:
		return(ACTION_CONTINUE);
	default:
		stat = stuc_datarate_confirm();
		if (stat == ACTION_BACK)
			goto loop;
		return(stat);
	}
}

stuc_datarate_confirm()
{
	char *answer;
	int stat;

	printf("\r\nThe data rate you've entered is not a standard SDSL data\r\n");
	printf("rate to our knowledge.  Are you sure you want to serve out\r\n");
	printf("SDSL at this exact data rate?\r\n\r\n");
	printf("Press Enter to continue or type BACK to go back\r\n");
	answer = prompt();
	stat = check_std_responses(answer);
	if (stat)
		return(stat);
	return(ACTION_CONTINUE);
}
