#include "types.h"
#include "ctype.h"
#include "strings.h"
#include "stdio.h"
#include "logic.h"

extern struct promptlevel prompt_array[];
extern int promptlevel;
extern int nokia_l2conv;

extern char *prompt();

extern int bitdsu_config_dtr();
extern int bitdsu_config_other();
extern int nokia_config_datarate();
extern int stuc_data_rate();

select_flavor()
{
	char *answer;
	char *cfgptr;
	int stat;

loop:	cfgptr = prompt_array[promptlevel].config_ptr;
	printf("\r\nPlease select your SDSL flavor:\r\n\r\n");
	printf("C: Copper Mountain\r\n");
	printf("N: Nokia (Covad)\r\n");
	printf("I: IFCTF SDSL (with pre-activation)\r\n");
	printf("O: Other bit-transparent configurations\r\n");
	printf("\r\nPlease make your selection: ");
	answer = prompt();
	stat = check_std_responses(answer);
	if (stat)
		return(stat);
	if (answer[0] == 'C' || answer[0] == 'c') {
		nokia_l2conv = 0;
		cfgptr += sprintf(cfgptr, "preact_type=CM\n");
		cfgptr += sprintf(cfgptr, "quat_orient=magfirst\n");
		printf("\r\nThe Copper Mountain flavor provides speed code indication,\r\n");
		printf("hence you don't need to configure the data rate.\r\n");
		prompt_array[promptlevel+1].func = bitdsu_config_dtr;
		prompt_array[promptlevel+1].config_ptr = cfgptr;
		return(ACTION_CONTINUE);
	} else if (answer[0] == 'I' || answer[0] == 'i') {
		nokia_l2conv = 0;
		cfgptr += sprintf(cfgptr, "preact_type=IFCTF\n");
		cfgptr += sprintf(cfgptr, "quat_orient=signfirst\n");
		printf("\r\nIFCTF pre-activation signals the data rate configured\r\n");
		printf("at the STU-C, hence you don't need to configure it on the STU-R.\r\n");
		prompt_array[promptlevel+1].func = bitdsu_config_dtr;
		prompt_array[promptlevel+1].config_ptr = cfgptr;
		return(ACTION_CONTINUE);
	} else if (answer[0] == 'N' || answer[0] == 'n') {
		nokia_l2conv = 1;
		prompt_array[promptlevel+1].func = nokia_config_datarate;
		prompt_array[promptlevel+1].config_ptr = cfgptr;
		stat = nokia_flavor_confirm();
		if (stat == ACTION_BACK)
			goto loop;
		return(stat);
	} else if (answer[0] == 'O' || answer[0] == 'o') {
		nokia_l2conv = 0;
		prompt_array[promptlevel+1].func = bitdsu_config_other;
		prompt_array[promptlevel+1].config_ptr = cfgptr;
		return(ACTION_CONTINUE);
	} else {
		printf("Invalid selection\r\n");
		goto loop;
	}
}

set_terminal_type()
{
	char *answer;
	char *cfgptr;
	int stat;

loop:	cfgptr = prompt_array[promptlevel].config_ptr;
	printf("\r\nFirst you need to select whether you want to use this DSU\r\n");
	printf("as a CPE device to connect to an SDSL service provided to\r\n");
	printf("you by a service provider, or if you are acting in a\r\n");
	printf("service provider role yourself and want to configure this\r\n");
	printf("DSU as a CO terminal.\r\n\r\n");
	printf("If you are connecting two DSUs over a dry pair, one needs\r\n");
	printf("to be configured as CO and the other as CPE.\r\n\r\n");
	printf("Please select CO or CPE: ");
	answer = prompt();
	stat = check_std_responses(answer);
	if (stat)
		return(stat);
	if (!strcasecmp(answer, "CO")) {
		cfgptr += sprintf(cfgptr, "terminal_type=C\n");
		nokia_l2conv = 0;
		prompt_array[promptlevel+1].func = stuc_data_rate;
		prompt_array[promptlevel+1].config_ptr = cfgptr;
		stat = stuc_ifctf_confirm();
		if (stat == ACTION_BACK)
			goto loop;
		return(stat);
	} else if (!strcasecmp(answer, "CPE")) {
		cfgptr += sprintf(cfgptr, "terminal_type=R\n");
		prompt_array[promptlevel+1].func = select_flavor;
		prompt_array[promptlevel+1].config_ptr = cfgptr;
		return(ACTION_CONTINUE);
	} else {
		printf("Invalid selection\r\n");
		goto loop;
	}
}

intro()
{
	char *answer;

	printf("Welcome to the DSU configuration wizard.  This program\r\n");
	printf("will ask you a series of questions about your desired\r\n");
	printf("configuration and will construct the necessary configuration\r\n");
	printf("files in FFS based on your answers.\r\n\r\n");
	printf("At any prompt you may respond with the keyword BACK to go\r\n");
	printf("back one question, STARTOVER to restart the configuration\r\n");
	printf("process from the beginning, or ABORT to cancel the entire\r\n");
	printf("configuration process.  All responses are case-insensitive.\r\n\r\n");
	printf("Press Enter to continue or type ABORT to cancel\r\n");
	answer = prompt();
	if (!answer || !strcasecmp(answer, "ABORT"))
		return(ACTION_ABORT);
	prompt_array[promptlevel+1].func = set_terminal_type;
	prompt_array[promptlevel+1].config_ptr =
					prompt_array[promptlevel].config_ptr;
	return(ACTION_CONTINUE);
}
