/*
 * This code reads HWCONF.TXT from FFS, calls the libutil function to parse it,
 * and provides access to the parsed set of parameters.
 */

#include "types.h"
#include "stdio.h"
#include "rt11ffs.h"
#include "../libffs/ffsimpl.h"
#include "monitor_api.h"

#define	MAX_PARAM		64	/* max # of param=value pairs */

static char hwconf_txt_buf[RT11FFS_AU_SIZE] __attribute__ ((aligned (2)));
static char parse_buf[(MAX_PARAM + 1) * 8] __attribute__ ((aligned (2)));

static const u_short hwconf_txt_filename[3]
	__attribute__ ((section (".rodata")))
	= {0x359B, 0x5FF6, 0x80D4};

int sysclk_freq;

extern char *textconf_search();

char *
hwconf_search(key)
	char *key;
{
	return textconf_search(parse_buf, key);
}

get_hwconf()
{
	struct find_file_results findstruct;
	int stat;
	char *str;

	if (monapi_ffsfindwrap(hwconf_txt_filename, &findstruct) < 0)
		return(-1);
	if (findstruct.total_size > 1) {
		monapi_error("HWCONF.TXT exceeds maximum size of %u bytes",
				RT11FFS_AU_SIZE);
		return(-1);
	}
	bcopy_words(findstruct.frags[0].addr, hwconf_txt_buf, RT11FFS_AU_SIZE);
	stat = parse_textconf(hwconf_txt_buf, RT11FFS_AU_SIZE, parse_buf,
				sizeof parse_buf, "HWCONF.TXT");
	if (stat < 0)
		return(stat);
	str = hwconf_search("sysclk_freq");
	if (!str) {
		monapi_error("sysclk_freq= setting is missing in HWCONF.TXT");
		return(-1);
	}
	if (!is_string_num(str)) {
		monapi_error("sysclk_freq= setting in HWCONF.TXT is invalid");
		return(-1);
	}
	sysclk_freq = atoi(str);
	return(0);
}
