#include "types.h"
#include "ctype.h"
#include "strings.h"
#include "stdio.h"
#include "rt11ffs.h"
#include "../libffs/ffsimpl.h"
#include "../flashw/api.h"
#include "monitor_api.h"
#include "logic.h"

extern struct flashw_api_table *flashw_api;

extern char config_txt_buf[];
extern struct promptlevel prompt_array[];
extern int promptlevel;
extern int nokia_l2conv;
extern char vclist_txt_buf[];

char oper_cmd_buf[RT11FFS_AU_SIZE];
int config_nblocks;

extern char *prompt();

static const u_short oper_cmd_filename[3]
	__attribute__ ((section (".rodata")))
	= {0x6045, 0x7080, 0x14CC};
static const u_short config_txt_filename[3]
	__attribute__ ((section (".rodata")))
	= {0x1526, 0x26EF, 0x80D4};
static const u_short vclist_txt_filename[3]
	__attribute__ ((section (".rodata")))
	= {0x8A04, 0x3B4C, 0x80D4};

config_zeropad(endptr)
	char *endptr;
{
	int nbytes, pad;

	nbytes = endptr - config_txt_buf;
	if (nbytes % RT11FFS_AU_SIZE) {
		pad = RT11FFS_AU_SIZE - (nbytes % RT11FFS_AU_SIZE);
		bzero(endptr, pad);
	} else
		pad = 0;
	config_nblocks = (nbytes + pad) / RT11FFS_AU_SIZE;
}

generate_oper_cmd()
{
	char *cp;

	cp = oper_cmd_buf;
	if (nokia_l2conv)
		cp += sprintf(cp, "RUN N1L2CS\n");
	else {
		cp += sprintf(cp, "MUX 114 BCLK180\n");
		cp += sprintf(cp, "MUX 115 BCLK180\n");
		cp += sprintf(cp, "RUN BITDSU\n");
	}
	bzero(cp, RT11FFS_AU_SIZE - (cp - oper_cmd_buf));
}

dump_generated_text(start)
	char *start;
{
	char *cp, *np;

	for (cp = start; *cp; cp = np + 1) {
		np = index(cp, '\n');
		if (!np)
			return;
		printf("%.*s\r\n", np - cp, cp);
	}
}

ensure_free_space()
{
	struct segment_scan_results scan[FFS_NSEGS];
	int i, freeblocks, neededblocks;

	monapi_scanffs(0, scan);
	for (i = 0, freeblocks = 0; i < FFS_NSEGS; i++)
		if (scan[i].valid_seg && !scan[i].has_errs)
			freeblocks += scan[i].free_blocks;
	neededblocks = config_nblocks + 1 + nokia_l2conv;
	if (freeblocks < neededblocks) {
		monapi_error("Not enough free space to store the new files");
		return(-1);
	}
	return(0);
}

write_to_ffs()
{
	struct ffs_create_options createopts;
	int stat;

	createopts.overwrite = 1;
	createopts.startseg = 0;
	createopts.contig = 0;
	stat = flashw_api->ffs_create_file(oper_cmd_filename, 1, oper_cmd_buf,
					&createopts);
	if (stat)
		return(stat);
	stat = flashw_api->ffs_create_file(config_txt_filename, config_nblocks,
					config_txt_buf, &createopts);
	if (stat)
		return(stat);
	if (nokia_l2conv) {
		stat = flashw_api->ffs_create_file(vclist_txt_filename, 1,
					vclist_txt_buf, &createopts);
		if (stat)
			return(stat);
	}
	printf("Configuration has been written to FFS\r\n");
	printf("You can now reboot the DSU with the REBOOT command\r\n");
	return(0);
}

finish()
{
	char *answer;
	int stat;

	config_zeropad(prompt_array[promptlevel].config_ptr);
	generate_oper_cmd();
loop:	printf("\r\nDSU configuration is now complete\r\n\r\n");
	printf("The OPER.CMD script has been generated as follows:\r\n\r\n");
	dump_generated_text(oper_cmd_buf);
	printf("\r\nThe CONFIG.TXT parameter list has been generated as follows:\r\n\r\n");
	dump_generated_text(config_txt_buf);
	printf("\r\nDo you accept this configuration (Y/N)? ");
	answer = prompt();
	stat = check_std_responses(answer);
	if (stat)
		return(stat);
	switch (answer[0]) {
	case 'Y':
	case 'y':
		break;
	case 'N':
	case 'n':
		return(ACTION_ABORT);
	default:
		printf("Invalid entry\r\n");
		goto loop;
	}
	if (ensure_free_space() < 0)
		return(ACTION_EXIT);
	write_to_ffs();
	return(ACTION_EXIT);
}
