#include "types.h"
#include "ctype.h"
#include "strings.h"
#include "stdio.h"
#include "logic.h"

extern struct promptlevel prompt_array[];
extern int promptlevel;

extern char *prompt();
extern int finish();

extern int sysclk_freq;
extern int nokia_data_rate;

ccitt115_synth_rate()
{
	char *answer;
	char *cfgptr;
	int stat, desnum, div, finbps;

loop:	cfgptr = prompt_array[promptlevel].config_ptr;
	printf("\r\nThe synthetic EIA-530 clock is generated by dividing down from the\r\n");
	printf("DSU's MC68302 system clock of %d.%06d MHz.\r\n",
		sysclk_freq / 1000000, sysclk_freq % 1000000);
	printf("You'll need to enter the desired bit rate in kbps and this configuration\r\n");
	printf("wizard will compute the divide ratio for the closest possible\r\n");
	printf("approximation.\r\n\r\n");
	printf("Please enter the desired bit rate in kbps: ");
	answer = prompt();
	stat = check_std_responses(answer);
	if (stat)
		return(stat);
	if (!is_string_num(answer)) {
		printf("Invalid entry\r\n");
		goto loop;
	}
	desnum = atoi(answer);
	if (desnum < nokia_data_rate) {
		printf("The EIA-530 clock should not be slower than the SDSL/ATM bit rate\r\n");
		goto loop;
	}
	div = sysclk_freq / (desnum * 1000);
	if (div < 10) {
		printf("The synthetic clock may not be faster than 1/10th of the SYSCLK frequency\r\n");
		goto loop;
	}
	cfgptr += sprintf(cfgptr, "ccitt_115=/%d\n", div);
	prompt_array[promptlevel+1].func = finish;
	prompt_array[promptlevel+1].config_ptr = cfgptr;
	finbps = sysclk_freq / div;
	printf("\r\nCCITT circuit 115 will be driven with SYSCLK divided by %d,\r\n", div);
	printf("resulting in a bit rate of %d.%03d kbps.\r\n", finbps / 1000,
		finbps % 1000);
	stat = generic_confirm();
	if (stat == ACTION_BACK)
		goto loop;
	return(stat);
}

config_l2conv_ccitt115()
{
	char *answer;
	char *cfgptr;
	int stat;

	cfgptr = prompt_array[promptlevel].config_ptr;
loop:	printf("\r\nAt what bit rate would you like to run the DSU->router EIA-530 link?\r\n\r\n");
	printf("Available options:\r\n\r\n");
	printf("1: BCLK (same as the SDSL/ATM bit rate)\r\n");
	printf("2: A synthetic clock (you'll be asked for the rate next)\r\n");
	printf("\r\nPlease make your selection: ");
	answer = prompt();
	stat = check_std_responses(answer);
	if (stat)
		return(stat);
	if (strlen(answer) != 1) {
inv:		printf("Invalid selection\r\n");
		goto loop;
	}
	switch (answer[0]) {
	case '1':
		cfgptr += sprintf(cfgptr, "ccitt_115=BCLK\n");
		prompt_array[promptlevel+1].func = finish;
		prompt_array[promptlevel+1].config_ptr = cfgptr;
		return(ACTION_CONTINUE);
	case '2':
		prompt_array[promptlevel+1].func = ccitt115_synth_rate;
		prompt_array[promptlevel+1].config_ptr = cfgptr;
		return(ACTION_CONTINUE);
	default:
		goto inv;
	}
}

config_l2conv_scc2()
{
	char *cfgptr;
	int stat;

	printf("\r\nWhen the DSU is acting as a Layer 2 converter, the EIA-530 link\r\n");
	printf("is not required to operate at the same bit rate as the SDSL link.\r\n");
	printf("There are separate clocks for data flowing from your router to the DSU\r\n");
	printf("(CCITT circuit 114) and for data flowing from the DSU to the router\r\n");
	printf("(circuit 115), and this DSU allows switching either BCLK (the SDSL bit\r\n");
	printf("clock) or a synthetic clock to each circuit.\r\n\r\n");
	printf("Because HDLC is almost always more bit-efficient than ATM, we recommend\r\n");
	printf("setting ccitt_114=BCLK, hence that is the configuration created by this\r\n");
	printf("wizard.  However, the EIA-530 bit rate in the DSU->router direction\r\n");
	printf("may be set higher to reduce the added latency and the slight chance\r\n");
	printf("of occasional dropped packets in the ATM->HDLC direction.\r\n");
	stat = generic_confirm();
	if (stat)
		return(stat);

	cfgptr = prompt_array[promptlevel].config_ptr;
	cfgptr += sprintf(cfgptr, "ccitt_114=BCLK\n");
	prompt_array[promptlevel+1].func = config_l2conv_ccitt115;
	prompt_array[promptlevel+1].config_ptr = cfgptr;
	return(ACTION_CONTINUE);
}
