#include "types.h"
#include "stdio.h"
#include "ctype.h"
#include "strings.h"
#include "console.h"
#include "../lib8973/typedefs.h"
#include "../lib8973/bitpump.h"
#include "../lib8973/bpstate.h"
#include "../lib8973/readmeter.h"

int show_meters_raw;

show_ipl()
{
	printf("%d\r\n", current_ipl());
	return(0);
}

show_aagc()
{
	DECLARE_MODE_PTR;
	u_char aagc;

	aagc = bp_mode_ptr->adc_control.again;
	if (aagc <= 5)
		printf("%d dB\r\n", aagc * 3);
	else
		printf("Invalid value in the AAGC register!\r\n");
	return(0);
}

show_mdisplay()
{
	printf("Meter readings are shown %s\r\n",
		show_meters_raw ? "raw" : "normalized");
	return(0);
}

show_meters()
{
	u_short value;
	short svalue;

	value = bp_read_meter(0, READMETER_INTERVAL);
	printf("Meter interval is %u symbols\r\n", value);
	printf("Meter readings are shown %s\r\n",
		show_meters_raw ? "raw" : "normalized");
	svalue = (short) bp_read_meter(0, READMETER_DCOFFSET);
	printf("DC adjustment: %d\r\n", svalue);
	svalue = (short) bp_read_meter(0,
			show_meters_raw ? READMETER_DC_RAW : READMETER_DC_NORM);
	printf("DC meter: %d\r\n", svalue);
	value = bp_read_meter(0,
		show_meters_raw ? READMETER_SLM_RAW : READMETER_SLM_NORM);
	printf("SLM: %u\r\n", value);
	value = bp_read_meter(0,
		show_meters_raw ? READMETER_FELM_RAW : READMETER_FELM_NORM);
	printf("FELM: %u\r\n", value);
	value = bp_read_meter(0, READMETER_OVERFLOW);
	printf("Overflow meter: %u\r\n", value);
	value = bp_read_meter(0,
		show_meters_raw ? READMETER_NLM_RAW : READMETER_NLM_NORM);
	printf("NLM: %u\r\n", value);
	value = bp_read_meter(0, READMETER_BER);
	printf("BER meter: %u\r\n", value);
	return(0);
}

show_symrate()
{
	printf("Symbol rate: %u kbaud\r\n", BP_global_state.symbol_rate * 4);
	printf("Data rate: %u kbps\r\n", BP_global_state.symbol_rate * 8);
	return(0);
}

show_vcxo()
{
	short value;

	value = (short) bp_read_meter(0, READMETER_VCXO);
	printf("%d\r\n", value);
	return(0);
}

static const struct keyword show_subcmds[] = {
	{"AAGC", 1, (long) &show_aagc},
	{"BCLK", 1, (long) &show_symrate},
	{"DATARATE", 1, (long) &show_symrate},
	{"IPL", 1, (long) &show_ipl},
	{"MDISPLAY", 2, (long) &show_mdisplay},
	{"METERS", 2, (long) &show_meters},
	{"QCLK", 1, (long) &show_symrate},
	{"SYMRATE", 1, (long) &show_symrate},
	{"VCXO", 1, (long) &show_vcxo},
	{NULL, 0, -1}};

cmd_show(cmd)
	char *cmd;
{
	struct param params[1];
	void (*subcmdfunc)();
	int ambigsubcmd;

	if (parse_cmd(cmd, 1, 1, params, NULL, NULL, NULL))
		return(0);
	ambigsubcmd = 0;
	subcmdfunc = (void (*)())
		find_keyword(params[0].text, params[0].len, show_subcmds,
				&ambigsubcmd);
	if ((long) subcmdfunc != -1)
		(*subcmdfunc)();
	else {
		if (ambigsubcmd)
			error("Ambiguous parameter");
		else
			error("Illegal parameter");
	}
	return(0);
}
