#include "types.h"
#include "stdio.h"
#include "ctype.h"
#include "strings.h"
#include "console.h"
#include "../lib8973/typedefs.h"
#include "../lib8973/bitpump.h"
#include "../lib8973/util.h"
#include "../lib8973/bpstate.h"

extern int show_meters_raw;

cmd_set_ipl(cmd)
	char *cmd;
{
	struct param params[1];
	u_long ipl;

	if (parse_cmd(cmd, 1, 1, params, NULL, NULL, NULL))
		return(0);
	if (parse_hexnum(params[0].text, params[0].len, &ipl))
		return(0);
	if (ipl & 0xFFFFFFF8) {
		error("Value too large");
		return(0);
	}
	splx(ipl);
	return(0);
}

cmd_set_symrate(cmd)
	char *cmd;
{
	struct param params[1];
	u_long val;

	if (parse_cmd(cmd, 1, 1, params, NULL, NULL, NULL))
		return(0);
	if (parse_decnum(params[0].text, params[0].len, &val))
		return(0);
	if (val % 4) {
		error("Symbol rate must be a multiple of 4 kbaud");
		return(0);
	}
	if (!is_datarate_supported(val * 2)) {
		error("Symbol rate %d not supported", val);
		return(0);
	}
	BP_global_state.symbol_rate = val >> 2;
	_BtReset(0);
	return(0);
}

cmd_set_datarate(cmd)
	char *cmd;
{
	struct param params[1];
	u_long val;

	if (parse_cmd(cmd, 1, 1, params, NULL, NULL, NULL))
		return(0);
	if (parse_decnum(params[0].text, params[0].len, &val))
		return(0);
	if (!is_datarate_supported(val)) {
		error("Data rate %d not supported", val);
		return(0);
	}
	BP_global_state.symbol_rate = val >> 3;
	_BtReset(0);
	return(0);
}

cmd_set_aagc(cmd)
	char *cmd;
{
	DECLARE_MODE_PTR;
	struct param params[1];
	u_long val;

	if (parse_cmd(cmd, 1, 1, params, NULL, NULL, NULL))
		return(0);
	if (parse_decnum(params[0].text, params[0].len, &val))
		return(0);
	switch (val) {
	case 0:
		bp_mode_ptr->adc_control.again = AGAIN0DB;
		break;
	case 3:
		bp_mode_ptr->adc_control.again = AGAIN3DB;
		break;
	case 6:
		bp_mode_ptr->adc_control.again = AGAIN6DB;
		break;
	case 9:
		bp_mode_ptr->adc_control.again = AGAIN9DB;
		break;
	case 12:
		bp_mode_ptr->adc_control.again = AGAIN12DB;
		break;
	case 15:
		bp_mode_ptr->adc_control.again = AGAIN15DB;
		break;
	default:
		error("Invalid AAGC setting");
	}
	return(0);
}

static const struct keyword mdisplay_modes[] = {
	{"NORMALIZED", 1, 0},
	{"RAW", 1, 1},
	{NULL, 0, -1}};

cmd_set_mdisplay(cmd)
	char *cmd;
{
	struct param params[1];
	int code, ambig = 0;

	if (parse_cmd(cmd, 1, 1, params, NULL, NULL, NULL))
		return(0);
	code = find_keyword(params[0].text, params[0].len, mdisplay_modes,
				&ambig);
	if (code != -1)
		show_meters_raw = code;
	else {
		if (ambig)
			error("Ambiguous mode keyword");
		else
			error("Invalid mode keyword");
	}
	return(0);
}

cmd_set_meter(cmd)
	char *cmd;
{
	struct param params[1];
	u_long val;

	if (parse_cmd(cmd, 1, 1, params, NULL, NULL, NULL))
		return(0);
	if (parse_decnum(params[0].text, params[0].len, &val))
		return(0);
	if (val & 0xFFFF0000) {
		error("Value too large");
		return(1);
	}
	_SetMeterArbitrary(val);
	return(0);
}

cmd_set_txgain(cmd)
	char *cmd;
{
	struct param params[1];
	int val;

	if (parse_cmd_plusminus(cmd, 1, 1, params))
		return(0);
	if (parse_signed_decnum(params[0].text, params[0].len, &val))
		return(0);
	bp_set_txgain(0, val);
	return(0);
}

cmd_set_vcxo(cmd)
	char *cmd;
{
	DECLARE_PTR;
	struct param params[1];
	int val;

	if (parse_cmd_plusminus(cmd, 1, 1, params))
		return(0);
	if (parse_signed_decnum(params[0].text, params[0].len, &val))
		return(0);
	SET_WORD(bp_ptr, vcxo_frequency_low, vcxo_frequency_high, val);
	return(0);
}

static const struct keyword set_subcmds[] = {
	{"AAGC", 1, (long) &cmd_set_aagc},
	{"BCLK", 1, (long) &cmd_set_datarate},
	{"DATARATE", 1, (long) &cmd_set_datarate},
	{"IPL", 1, (long) &cmd_set_ipl},
	{"MDISPLAY", 2, (long) &cmd_set_mdisplay},
	{"METER", 2, (long) &cmd_set_meter},
	{"QCLK", 1, (long) &cmd_set_symrate},
	{"SYMRATE", 1, (long) &cmd_set_symrate},
	{"TXGAIN", 1, (long) &cmd_set_txgain},
	{"VCXO", 1, (long) &cmd_set_vcxo},
	{NULL, 0, -1}};

cmd_set(cmd)
	char *cmd;
{
	char *cp = cmd, *subcmd;
	int count;
	void (*subcmdfunc)();
	int ambigsubcmd;

	while (*cp == ' ')
		cp++;
	if (!issym(*cp)) {
		error("Parameter required");
		return(0);
	}
	for (subcmd = cp, count = 0; issym(*cp); cp++)
		count++;
	ambigsubcmd = 0;
	subcmdfunc = (void (*)())
			find_keyword(subcmd, count, set_subcmds, &ambigsubcmd);
	if ((long) subcmdfunc != -1)
		(*subcmdfunc)(cp);
	else {
		if (ambigsubcmd)
			error("Ambiguous parameter");
		else
			error("Illegal parameter");
	}
	return(0);
}
