#include "types.h"
#include "stdio.h"
#include "ctype.h"
#include "strings.h"
#include "console.h"

extern int cmd_alb();
extern int cmd_ber();
extern int cmd_deposit();
extern int cmd_erle();
extern int cmd_examine();
extern int cmd_exit();
extern int cmd_hexdump();
extern int cmd_initregs();
extern int cmd_isopulse();
extern int cmd_reset();
extern int cmd_rx();
extern int cmd_selftest();
extern int cmd_set();
extern int cmd_show();
extern int cmd_tone();
extern int cmd_tx();

const struct keyword commands[] = {
	{"ALB", 1, (long) &cmd_alb},
	{"BER", 2, (long) &cmd_ber},
	{"BTRESET", 2, (long) &cmd_reset},
	{"DEPOSIT", 1, (long) &cmd_deposit},
	{"ERLE", 2, (long) &cmd_erle},
	{"EXAMINE", 1, (long) &cmd_examine},
	{"EXIT", 3, (long) &cmd_exit},
	{"HEXDUMP", 1, (long) &cmd_hexdump},
	{"INITREGS", 2, (long) &cmd_initregs},
	{"ISOPULSE", 2, (long) &cmd_isopulse},
	{"RESET", 2, (long) &cmd_reset},
	{"RX", 2, (long) &cmd_rx},
	{"SELFTEST", 3, (long) &cmd_selftest},
	{"SET", 3, (long) &cmd_set},
	{"SHOW", 2, (long) &cmd_show},
	{"TONE", 2, (long) &cmd_tone},
	{"TX", 2, (long) &cmd_tx},
	{NULL, 0, -1}};

console()
{
	char command[80];

	while (1) {
		char *cp;
		int count;

prompt:		printf("BPTEST>");
		for (cp = command, count = 0; ; ) {
			char ch;

			ch = toascii(getchar());
			switch (ch) {
			case '\0':	/* ignore NULs */
				continue;
			case 0x03:	/* ^C */
				printf("^C\r\n");
				goto prompt;
			case 0x08:	/* BS */
			case 0x7F:	/* DEL */
				if (!count)
					continue;
				printf("\b \b");
				cp--;
				count--;
				continue;
			case '\r':	/* CR */
				printf("\r\n");
				goto process_command;
			case 0x15:	/* ^U */
				printf("^U\r\n");
				goto prompt;
			}
			if (iscntrl(ch) || count == 79) {
				putchar(0x07);
				continue;
			}
			putchar(ch);
			*cp++ = ch;
			count++;
		}
process_command:
		*cp = '\0';
		/* Ignore comments */
		cp = index(command, '!');
		if (cp)
			*cp = '\0';
		for (cp = command; *cp == ' '; cp++)
			;
		if (!*cp)
			continue;
		if (exec_console_cmd(cp))
			break;
	}
	return(0);
}

exec_console_cmd(cmd)
	char *cmd;
{
	char *cp;
	int count;
	int (*cmdfunc)();
	int ambigcmd;

	if (!issym(*cmd)) {
		error("Illegal command");
		return(0);
	}
	for (cp = cmd, count = 0; issym(*cp); cp++)
		count++;
	ambigcmd = 0;
	cmdfunc = (int (*)()) find_keyword(cmd, count, commands, &ambigcmd);
	if ((long) cmdfunc != -1)
		return (*cmdfunc)(cp);
	else {
		if (ambigcmd)
			error("Ambiguous command");
		else
			error("Illegal command");
		return(0);
	}
}
