#include "types.h"
#include "stdio.h"
#include "ctype.h"
#include "strings.h"
#include "console.h"
#include "../lib8973/typedefs.h"
#include "../lib8973/bitpump.h"

cmd_exit(cmd)
	char *cmd;
{
	if (parse_cmd(cmd, 0, 0, NULL, NULL, NULL, NULL))
		return(0);
	return(1);
}

cmd_initregs(cmd)
	char *cmd;
{
	if (parse_cmd(cmd, 0, 0, NULL, NULL, NULL, NULL))
		return(0);
	_BtInitialize(0);
	return(0);
}

cmd_isopulse(cmd)
	char *cmd;
{
	DECLARE_MODE_PTR;
	struct param params[2];
	u_long meter;
	int symbol;

	if (parse_cmd_plusminus(cmd, 2, 2, params))
		return(0);
	if (params[0].len != 2) {
invsym:		error("Invalid symbol value");
		return(0);
	}
	switch (params[0].text[0]) {
	case '+':
		symbol = 2;
		break;
	case '-':
		symbol = 0;
		break;
	default:
		goto invsym;
	}
	switch (params[0].text[1]) {
	case '1':
		symbol |= 1;
		break;
	case '3':
		break;
	default:
		goto invsym;
	}
	if (parse_decnum(params[1].text, params[1].len, &meter))
		return(0);
	if (meter & 0xFFFF0000) {
		error("Value too large");
		return(1);
	}
	_SetMeterArbitrary(meter);
	bp_mode_ptr->transmitter_modes.isolated_pulse = symbol;
	bp_mode_ptr->transmitter_modes.data_source = ISOLATED_PULSE;
	bp_mode_ptr->transmitter_modes.transmitter_off = 0;
	return(0);
}

cmd_reset(cmd)
	char *cmd;
{
	if (parse_cmd(cmd, 0, 0, NULL, NULL, NULL, NULL))
		return(0);
	_BtReset(0);
	return(0);
}

static const struct keyword rx_modes[] = {
	{"RAW", 1, SELECT_DETECTOR_OUTPUT},
	{"LOOPBACK", 1, SELECT_TRANSMITTER_INPUT},
	{"DESCRAMBLED", 1, SELECT_DESCRAMBLER_OUTPUT},
	{NULL, 0, -1}};

cmd_rx(cmd)
	char *cmd;
{
	struct param params[1];
	int code, ambig = 0;

	if (parse_cmd(cmd, 1, 1, params, NULL, NULL, NULL))
		return(0);
	code = find_keyword(params[0].text, params[0].len, rx_modes, &ambig);
	if (code != -1)
		bp_set_rxmode(0, code);
	else {
		if (ambig)
			error("Ambiguous mode keyword");
		else
			error("Invalid mode keyword");
	}
	return(0);
}

cmd_selftest(cmd)
	char *cmd;
{
	if (parse_cmd(cmd, 0, 0, NULL, NULL, NULL, NULL))
		return(0);
	_SelfTest(0);
	return(0);
}

cmd_tone(cmd)
	char *cmd;
{
	DECLARE_MODE_PTR;
	struct param params[1];
	u_long meter;

	if (parse_cmd(cmd, 1, 1, params, NULL, NULL, NULL))
		return(0);
	if (parse_decnum(params[0].text, params[0].len, &meter))
		return(0);
	if (meter & 0xFFFF0000) {
		error("Value too large");
		return(1);
	}
	_SetMeterArbitrary(meter);
	bp_mode_ptr->transmitter_modes.isolated_pulse = 0;	/* +/-3 */
	bp_mode_ptr->transmitter_modes.data_source = ALTERNATING_SYMBOL;
	bp_mode_ptr->transmitter_modes.transmitter_off = 0;
	return(0);
}

static const struct keyword tx_modes[] = {
	{"2L1S", 1, SCRAMBLED_TWO_LEVEL_ONES},
	{"4L1S", 1, SCRAMBLED_FOUR_LEVEL_ONES},
	{"EXTERNAL", 1, SCRAMBLED_FOUR_LEVEL_DATA},
	{"LOOPBACK", 1, DETECTOR_LOOPBACK},
	{"RAW2", 4, UNSCRAMBLED_TWO_LEVEL_DATA},
	{"RAW4", 4, UNSCRAMBLED_FOUR_LEVEL_DATA},
	{"OFF", 1, -2},
	{NULL, 0, -1}};

cmd_tx(cmd)
	char *cmd;
{
	struct param params[1];
	int code, txen, ambig = 0;

	if (parse_cmd(cmd, 1, 1, params, NULL, NULL, NULL))
		return(0);
	code = find_keyword(params[0].text, params[0].len, tx_modes, &ambig);
	if (code != -1) {
		if (code == -2) {
			txen = 0;
			code = 0;
		} else
			txen = 1;
		bp_set_tx(0, txen, code);
	} else {
		if (ambig)
			error("Ambiguous mode keyword");
		else
			error("Invalid mode keyword");
	}
	return(0);
}
