
/*  ************************************************************************  *
 *				   xmswatch.h				      *
 *  ************************************************************************  */

/*  Structures and definitions used for analysing XMS memory allocation  */

#include    "standard.h"

#pragma pack (1)

/*  Information about extended memory blocks is built into a list of HANDLE
    structures (linked in increasing order of linear address).	*/

struct HANDLE {
    struct HANDLE *pNext;
    WORD wFlags;
    WORD wHandle;
    DWORD dwBase;
    WORD wSizeInKB;
    BYTE cLocks;
    CHAR cOwner [9];	    // eight bytes for name, plus null terminator
};

/*  Bits for the flag word  */

#define POOL_HANDLE	0x0001	    // only one of
#define FREE_EMB	0x0002	    // these three
#define USED_EMB	0x0004	    // may be set

#define PHYSICAL_EMB	0x0010

#define ENTRY_USED	0x8000

/*  The HANDLE structures are arranged in an array immediately after a few
    fields that help with list management.  */

struct LIST {
    struct HANDLE *pLowest;
    struct HANDLE *pUnused;
    struct HANDLE *pEnd;
    struct HANDLE array [];
};

#pragma pack ()

/*  Functions provided in LIST.C for list management  */

struct LIST *CreateList (WORD);
struct HANDLE *GetUnusedEntry (struct LIST *);
struct HANDLE *AddEntry (struct LIST *, DWORD);
void LinkEntry (struct LIST *, struct HANDLE *);

/*  ************************************************************************  */

